#ifndef __KMTRACE_SUPPRESS_LIST_DIALOG__HH__
#define __KMTRACE_SUPPRESS_LIST_DIALOG__HH__

// KDE includes
#include <kdialogbase.h>
#include <klistview.h>

// kmtraceviewer includes
#include "KMtraceLeak.hh"
#include "KMtraceModel.hh"
#include "KMtraceSuppressDialog.hh"

/**
 * A dialog presenting a list of currently suppressed leak types. The
 * dialog presents a list view of all suppresed leak types and provides
 * buttons to modify, delete or add suppressions.
 *
 * The dialog takes its data from the kde.excludes file on startup and
 * keeps them for the rest of the live-time of the program. If the user
 * doesn't save the suppressions in the menu bar the suppression made in
 * this dialog are valid only until the end of the current session.
 *
 * The dialog is opened in non-modal mode.
 *
 * If pressing on the add button, a KMtraceSuppressDialog
 * opens where the user can enter the data of the leak type
 * to suppress.
 *
 * @short The dialog showing the list of the currently active suppressions
 * @author Andreas Baumann <andreas_baumann@users.sourceforge.net>
 * @see KMtraceSuppresionViewItem, KMtraceModel, KMtraceSuppressDialog
 * @version $ProjectMajorVersion: 0 $
 */
class KMtraceSuppressListDialog : public KDialogBase
{
   Q_OBJECT
   
   public:
      KMtraceSuppressListDialog( KMtraceModel *model,
                                 QWidget *parent = 0,
                                 const char *name = 0,
                                 bool modal = true );
      void setModel( KMtraceModel *model );

   public slots:
      void slotModelChanged( );
      void slotAddSuppressionDone( );

   protected:
      // contains the suppressions
      KMtraceModel *m_model;
      
      // the list view showing all suppresions in a sortable table
      KListView *m_listView;

      // the suppress dialog (simple version to add a suppression)
      KMtraceSuppressDialog *m_suppressDialog;

      // whether the suppress edit dialog is currently running
      bool m_suppressDialogRunning;
   
   protected slots:
      void slotUser1( );
      void slotUser2( );
      void slotCancel( );
      void slotSuppress( KMtraceLeak *leak, QString string );

   signals:
      void done( );
      
   private:
      virtual void done( int i ) { KDialogBase::done( i ); }
};

#endif
