// Qt includes
#include <qobject.h>
#include <qwidget.h>
#include <qstring.h>
#include <qtextstream.h>

// KDE includes
#include <klocale.h>

// KMtraceViewer includes
#include "KMtraceModel.hh"
#include "KMtraceStatisticsView.hh"
#include "KMtraceStatisticsView.moc"

KMtraceStatisticsView::KMtraceStatisticsView( QWidget *parent, KMtraceModel *model )
  : QLabel( parent )
{
   setModel( model );
}

void KMtraceStatisticsView::setModel( KMtraceModel *model )
{
   m_model = model;
   updateView( );
}

void KMtraceStatisticsView::updateView( )
{
   QString result;

   if( m_model ) {
      QTextOStream( &result ) << i18n( "Total memory allocated: " ) <<
                                 m_model->getNofTotalAllocatedBytes( ) <<
                                 i18n( " bytes in " ) <<
                                 m_model->getNofTotalAllocatedBlocks( ) <<
                                 i18n( " blocks.\n" ) <<
                                 i18n( "Maximum memory allocated: " ) <<
                                 m_model->getNofMaximumAllocatedBytes( ) <<
                                 i18n( " bytes in " ) <<
                                 m_model->getNofMaximumAllocatedBlocks( ) <<
                                 i18n( " blocks.\n" ) <<
                                 i18n( "Total memory leaked: " ) <<
                                 m_model->getNofTotalLeaksBytes( ) <<
                                 i18n( " bytes in " ) <<
                                 m_model->getNofTotalLeaksBlocks( ) <<
                                 i18n( " blocks." );
   } else {
      QTextOStream( &result ) << i18n( "No file loaded, so no statistics available..." );
   }
         
   setText( result );
}

void KMtraceStatisticsView::slotModelChanged( )
{
   updateView( );
}
