// code copied from kedctl2.cpp (KEdFind in kdelib package)

// Qt includes
#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qhbox.h>

// KDE includes
#include <klocale.h>
#include <kcombobox.h>

// kmtraceviewer includes
#include "KMtraceLeaksFindDialog.hh"
#include "KMtraceLeaksFindDialog.moc"

////////////////////////////////////////////////////////////////////
//
// Find Leak Dialog
//

class KMtraceLeaksFindDialog::KMtraceLeaksFindPrivate
{
public:
    KMtraceLeaksFindPrivate( QWidget *parent ) {
       typeCombo = new KComboBox( false, parent, "call type combo" );
       typeCombo->insertItem( i18n( "Library" ) );
       typeCombo->insertItem( i18n( "Module" ) );
       typeCombo->insertItem( i18n( "Function" ) );

       textCombo = new KHistoryCombo( parent, "value" );
       textCombo->setMaxCount( 20 ); // just some default
    }
    ~KMtraceLeaksFindPrivate() {
	delete typeCombo;
	delete textCombo;
    }

    
    KComboBox *typeCombo;
    KHistoryCombo *textCombo;
};


KMtraceLeaksFindDialog::KMtraceLeaksFindDialog( QWidget *parent, const char *name, bool modal )
  :KDialogBase( parent, name, modal, i18n("Find Leaks"),
		modal ? User1|Cancel : User1|Close, User1, false, i18n("&Find") )
{
  setWFlags( WType_TopLevel );

  QWidget *page = new QWidget( this );
  setMainWidget(page);
  QVBoxLayout *topLayout = new QVBoxLayout( page, 0, spacingHint() );
  QGridLayout *searchLayout = new QGridLayout( topLayout );

  d = new KMtraceLeaksFindPrivate( page );

  QLabel *labelType = new QLabel( i18n( "Where:" ), page, "where" );
  searchLayout->addWidget( labelType, 1, 0 );
  d->typeCombo->setMinimumWidth(fontMetrics().maxWidth()*20);
  d->typeCombo->setCurrentItem( 2 );
  searchLayout->addWidget( d->typeCombo, 1, 1 );

  QString text = i18n("Find:");
  QLabel *label = new QLabel( text, page , "find" );
  searchLayout->addWidget( label, 2, 0 );

  d->textCombo->setMinimumWidth(fontMetrics().maxWidth()*20);
  d->textCombo->setFocus();

  connect(d->textCombo, SIGNAL(textChanged ( const QString & )),
          this,SLOT(textSearchChanged ( const QString & )));

  searchLayout->addWidget(d->textCombo, 2, 1);

  group = new QVButtonGroup( i18n("Options"), page );
  topLayout->addWidget( group );

  QHBox* row1 = new QHBox( group );
  
  text = i18n("Case &Sensitive");
  sensitive = new QCheckBox( text, row1, "case");
  text = i18n("Find &Backwards");
  
  enableButton( KDialogBase::User1, !d->textCombo->currentText().isEmpty() );

  if ( !modal )
    connect( this, SIGNAL( closeClicked() ), this, SLOT( slotCancel() ) );
}

KMtraceLeaksFindDialog::~KMtraceLeaksFindDialog()
{
    delete d;
}

void KMtraceLeaksFindDialog::textSearchChanged ( const QString &text )
{
   enableButton( KDialogBase::User1, !text.isEmpty() );
}

void KMtraceLeaksFindDialog::slotCancel( void )
{
  emit done();
  d->textCombo->clearEdit();
  KDialogBase::slotCancel();
}

void KMtraceLeaksFindDialog::slotUser1( void )
{
  if( !d->textCombo->currentText().isEmpty() )
  {
    d->textCombo->addToHistory( d->textCombo->currentText() );
    emit search();
  }
}


QString KMtraceLeaksFindDialog::getText() const
{
    return d->textCombo->currentText();
}


void KMtraceLeaksFindDialog::setText(QString string)
{
  d->textCombo->setEditText(string);
  d->textCombo->lineEdit()->selectAll();
}

int KMtraceLeaksFindDialog::getType() const
{
    return d->typeCombo->currentItem();
}


void KMtraceLeaksFindDialog::setType(int index)
{
  d->typeCombo->setCurrentItem(index);
}

void KMtraceLeaksFindDialog::setCaseSensitive( bool b )
{
  sensitive->setChecked( b );
}

bool KMtraceLeaksFindDialog::case_sensitive() const
{
  return sensitive->isChecked();
}

KHistoryCombo * KMtraceLeaksFindDialog::searchCombo() const
{
    return d->textCombo;
}

void KMtraceLeaksFindDialog::virtual_hook( int id, void *data )
{
   KDialogBase::virtual_hook( id, data );
}
