/***************************************************************************
                 kstgfxtextmousehandler.cpp  -  description
                             -------------------
    begin                : 2005
    copyright            : (C) 2005 by University of British Columbia
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
 
#include <qpainter.h>

#include "kstgfxtextmousehandler.h"
#include "kstgfxmousehandlerutils.h"
#include "kst.h"
#include "kstdoc.h"
#include "kstviewlabel.h"
#include "kstviewwidget.h"

KstGfxTextMouseHandler::KstGfxTextMouseHandler(KstTopLevelViewPtr top)
  : KstGfxMouseHandler(top) {
 
  // initial default settings before any sticky settings
  KstViewLabelPtr defaultLabel = new KstViewLabel(QString::null);
  defaultLabel->setAutoResize(true);
  defaultLabel->setForegroundColor(Qt::black);
  defaultLabel->setBackgroundColor(Qt::white);
  defaultLabel->setTransparent(true);
  _defaultObject = KstViewObjectPtr(defaultLabel); 
}  


KstGfxTextMouseHandler::~KstGfxTextMouseHandler() {
}


void KstGfxTextMouseHandler::pressMove(const QPoint& pos, bool shift) {
  if (_cancelled || !_mouseDown) {
    return;  
  }
  
  QRect old = _prevBand;
  
  _prevBand = KstGfxMouseHandlerUtils::newRect(pos, _mouseOrigin, shift);
  
  if (old != _prevBand) {
    QPainter p;
    p.begin(_top->widget());
    p.setPen(QPen(Qt::black, 0, Qt::SolidLine));
    p.setRasterOp(Qt::NotROP);
    if (old.topLeft() != QPoint(-1, -1)) {
      p.drawRect(old);
    } 
    p.drawRect(_prevBand);
    p.end();
  }
}


void KstGfxTextMouseHandler::releasePress(const QPoint& pos, bool shift) {
  Q_UNUSED(shift)
  Q_UNUSED(pos)
      
  if (!_mouseDown) {
    // if mouse was never down, pretend it wasn't released
    return;
  }
  _mouseDown = false;
  
  // once released, create a new text object and popup the edit dialog
  if (!_cancelled && _mouseOrigin != pos) {
    KstViewLabelPtr label = new KstViewLabel(QString::null);
    copyDefaults(KstViewObjectPtr(label));
    _top->appendChild(KstViewObjectPtr(label));
    label->move(_prevBand.topLeft());
    label->resize(_prevBand.size());
    label->showDialog(KstTopLevelViewPtr(_top));
    KstApp::inst()->document()->setModified();
  }
  _prevBand = QRect(-1, -1, 0, 0);
}


// vim: ts=2 sw=2 et
