/***************************************************************************
                                dateparser.h
                             -------------------
    begin                : Nov 07, 2005
    copyright            : (C) 2005 The University of Toronto
    email                :
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATEPARSER_H
#define DATEPARSER_H

#include <extdatetime.h>
#include "kst_export.h"

namespace KST {
  /*
  All times represented as doubles are the number of milliseconds since Jan 01
  1970 00:00:00.  Negative times are before then.
  */
  KST_EXPORT extern ExtDateTime parsePlanckDate(const QString& dateString);
  KST_EXPORT extern double extDateTimeToMilliseconds(const ExtDateTime& edt);
  KST_EXPORT extern ExtDateTime millisecondsToExtDateTime(double ms);
}

#endif
// vim: ts=2 sw=2 et
