// -*- c++ -*-

/*
 *  Copyright (C) 2001-2004, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef KJSEMBEDJSPROXY_H
#define KJSEMBEDJSPROXY_H

#include <kjs/object.h>
#include "global.h"

namespace KJSEmbed {

class JSObjectProxy;
class JSValueProxy;
class JSOpaqueProxy;

/**
 * Base class for all proxy objects.
 *
 * @version $Id: jsproxy.h,v 1.2 2004/11/24 06:37:02 staikos Exp $
 * @author Richard Moore, rich@kde.org
 */
class KJSEMBED_EXPORT JSProxy : public KJS::ObjectImp
{
public:
  /** Identifies the owner of the currently wrapped pointer */
  enum Owner { Native, JavaScript };
    /**
     * Structure to store information about a method.
     */
    struct MethodTable {
	int id;
	const char *name;
    };

    /** Identifiers for the various types of proxy. */
    enum ProxyType {
	UnknownProxy,
	ObjectProxy,
	ValueProxy,
	OpaqueProxy
    };

    JSProxy( int type );
    virtual ~JSProxy();


    /** Returns the type of the proxy. */
    int proxyType() const { return proxytype; }

    /** Returns true iff this is a JSObjectProxy. */
    bool isObjectProxy() const { return proxytype == ObjectProxy; }

    /** Returns true iff this is a JSValueProxy. */
    bool isValueProxy() const { return proxytype == ValueProxy; }

    /** Returns true iff this is a JSOpaqueProxy. */
    bool isOpaqueProxy() const { return proxytype == OpaqueProxy; }

    /** Returns this object as a JSObjectProxy or 0 if the type is wrong. */
    JSObjectProxy *toObjectProxy();

    /** Returns this object as a JSValueProxy or 0 if the type is wrong. */
    JSValueProxy *toValueProxy();

    /** Returns this object as a JSOpaqueProxy or 0 if the type is wrong. */
    JSOpaqueProxy *toOpaqueProxy();

    /**
     * Returns the contents of this proxy as a void * pointer. This method
     * should be virtual, but is not for b/c.
     */
    //void *toVoidStar(); // KDE 4, virtual

    /** Returns true iff the content of this proxy inherits the specified base-class. */
    bool inherits( const char *clazz );

    /**
     * Converts the specified ValueImp to a JSProxy if possible, if the
     * ValueImp is not a JSProxy then 0 is returned.
     */
    static JSProxy *toProxy( KJS::ValueImp *imp );

    /**
     * Converts the specified ValueImp to a JSObjectProxy if possible, if the
     * ValueImp is not a JSObjectProxy then 0 is returned.
     */
    static JSObjectProxy *toObjectProxy( KJS::ValueImp *imp );

    /**
     * Converts the specified ValueImp to a JSValueProxy if possible, if the
     * ValueImp is not a JSValueProxy then 0 is returned.
     */
    static JSValueProxy *toValueProxy( KJS::ValueImp *imp );

    /**
     * Converts the specified ValueImp to a JSOpaqueProxy if possible, if the
     * ValueImp is not a JSOpaqueProxy then 0 is returned.
     */
    static JSOpaqueProxy *toOpaqueProxy( KJS::ValueImp *imp );

    /**
    * Transfers ownership of the contained pointer to C++ or Javascript.
    * JavaScript - Javascript GC will delete the pointer
    * Native - Javascript will not delete the pointer, but just the proxy.
    */
    void setOwner( Owner state = Native ) { ownership = state; }

    /**
    * Returns the current ownership.
    */
    Owner owner() const { return ownership; }

protected:
    /**
    *  Who really owns the current pointer
    */
    Owner ownership;
private:
    int proxytype;
    class JSProxyPrivate *d;
};

} // namespace KJSEmbed

#endif // KJSEMBEDJSPROXYIMP_H

// Local Variables:
// c-basic-offset: 4
// End:
