/***************************************************************************
 * dict.h
 * This file is part of the KDE project
 * copyright (C)2004-2005 by Sebastian Sauer (mail@dipe.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 ***************************************************************************/

#ifndef KROSS_API_DICT_H
#define KROSS_API_DICT_H

#include <qstring.h>
#include <qmap.h>

#include "object.h"
#include "value.h"

namespace Kross { namespace Api {

//the Dict class is unused at the moment. Do we even need it?
    /**
     * The Dict class implementates \a Value to handle
     * key=value base dictonaries/maps.
     */
    class Dict : public Value< List, QMap<QString, Object*> >
    {
            friend class Value< List, QMap<QString, Object*> >;
        protected:
            Dict(const QMap<QString, Object*>& value, const QString& name = "dict");
        public:
            virtual ~Dict();

            /// See \see Kross::Api::Object::getClassName
            virtual const QString getClassName() const;

            /// See \see Kross::Api::Object::getDescription
            virtual const QString getDescription() const;
    };

}}

#endif

