/***************************************************************************
                          knewaccount.cpp  -  description
                             -------------------
    begin                : Thu Aug 29 2002
    copyright            : (C) 2002 by Richard Garand
    email                : richard@garandnet.net
    $Id: knewaccount.cpp,v 1.5 2002/09/13 03:32:26 richard Exp $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kmainwindow.h>
 
#include "knewaccount.h"
#include "kbudget.h"
#include "kbudgetdoc.h"

KNewAccount::KNewAccount(KMainWindow* parent, KBudgetDoc* d, int id)
  : KDialogBase(parent, "knewaccount", false, i18n("New Account"), Ok|Cancel), doc(d), account(id)
{
  QWidget* page = new QWidget(this);
  setMainWidget(page);
  QGridLayout* grid = new QGridLayout(page);
  
  QLabel* lb = new QLabel(i18n("Name:"), page);
  grid->addWidget(lb, 0, 0);
  name = new KLineEdit(page);
  grid->addWidget(name, 0, 1);
  
  lb = new QLabel(i18n("Type:"), page);
  grid->addWidget(lb, 1, 0);
  type = new KComboBox(page);
  grid->addWidget(type, 1, 1);
  
  lb = new QLabel(i18n("Initial balance:"), page);
  grid->addWidget(lb, 2, 0);
  initialBalance = new KDoubleNumInput(page);
  grid->addWidget(initialBalance, 2, 1);

  type->insertItem(i18n("Income"));
  type->insertItem(i18n("Expense"));
  type->insertItem(i18n("Cash"));

  initialBalance->setPrecision(2);

  if ( id >= 0 ) {
    Account& acct = doc->getAccount(id);
    name->setText(acct.name());
    type->setCurrentItem((int)acct.type());
    type->setEnabled(false);
    initialBalance->setValue(acct.startingBalance());
    setCaption(i18n("Edit Account"));
  }
}

KNewAccount::~KNewAccount()
{
}

void KNewAccount::slotOk()
{
  QString acctName = name->text();
  int acctType = type->currentItem();
  float balance = (float)initialBalance->value();

  if ( !acctName.stripWhiteSpace().length() )
    KMessageBox::sorry(0, i18n("You must enter an account name"));
  else {
    doc->beginUndoGroup();
    if ( account < 0 )
      doc->newAccount((Account::types)acctType, acctName, balance);
    else {
      Account& acct = doc->getAccount(account);
      acct.setName(acctName);
      acct.setStartingBalance(balance);
    }
    doc->endUndoGroup();
    KDialogBase::slotOk();
  }
}
