/*
 * KHeiseReg
 *
 * A utility to search for articles within the Heise register.
 *
 * Copyright (C) 2002 Oliver Gantz <Oliver.Gantz@ePost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef ARTICLEVIEW_H
#define ARTICLEVIEW_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qlistview.h>
#include <qstring.h>
#include <qcstring.h>
#include <qwidget.h>

#include <klistview.h>
#include <kconfig.h>
#include <kpopupmenu.h>
#include <kaction.h>

#include "regfile.h"



#define ARTICLE_COL_TITLE			0
#define ARTICLE_COL_SUBTITLE	1
#define ARTICLE_COL_MAGAZINE	2
#define ARTICLE_COL_EDITION		3



class ArticleViewItem: public KListViewItem
{
public:
	ArticleViewItem(QListView *parent = 0, const char *name = 0);
	virtual ~ArticleViewItem();

	virtual QString key(int column, bool) const;

	void setEntry(const RegEntry &e);

	bool containsEntry(const RegEntry &e);

	QString title() const;
	QString subTitle() const;
	QString magazine() const;
	int magazineID() const;
	int edition() const;
	int year() const;
		
	QString authors() const;
	QString editor() const;
	int page() const;
	QString links() const;

private:
	QString m_authors, m_editor, m_links;
	int m_magid, m_edition, m_year, m_page;
	QString m_edition_key;
};


inline QString ArticleViewItem::title() const
{	return text(ARTICLE_COL_TITLE); }


inline QString ArticleViewItem::subTitle() const
{	return text(ARTICLE_COL_SUBTITLE); }


inline QString ArticleViewItem::magazine() const
{	return text(ARTICLE_COL_MAGAZINE); }


inline int ArticleViewItem::magazineID() const
{	return m_magid; }


inline int ArticleViewItem::edition() const
{	return m_edition; }


inline int ArticleViewItem::year() const
{	return m_year; }


inline QString ArticleViewItem::authors() const
{	return m_authors; }


inline QString ArticleViewItem::editor() const
{	return m_editor; }


inline int ArticleViewItem::page() const
{	return m_page; }


inline QString ArticleViewItem::links() const
{	return m_links; }




class ArticleView: public KListView
{
	Q_OBJECT
public:
	ArticleView(QWidget *parent = 0, const char *name = 0);
	virtual ~ArticleView();

	void readOptions();
	void saveOptions();

	void plugContextMenu(KAction *action);

	KPopupMenu *contextMenu();

public slots:
	bool containsEntry(const RegEntry &entry);
	void addEntry(const RegEntry &entry);

private slots:
	void rightButtonClickedSlot(QListViewItem *item, const QPoint &point, int);

private:
	KConfig *config;

	bool got_tooltips;

	QListViewItem *selectedItem;

	KPopupMenu *conMenu;
};


#endif // ARTICLEVIEW_H
