/*
 * KHeiseReg
 *
 * A utility to search for articles within the Heise register.
 *
 * Copyright (C) 2002 Oliver Gantz <Oliver.Gantz@ePost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef APPENDDLG_H
#define APPENDDLG_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qwidget.h>
#include <qstring.h>
#include <qlabel.h>

#include <kfiledialog.h>
#include <kurl.h>
#include <kconfig.h>
#include <kaction.h>
#include <kdialog.h>
#include <kpushbutton.h>
#include <kio/job.h>
#include <kio/jobclasses.h>
#include <kprocess.h>


class AppendFileDlg: public KFileDialog
{
	Q_OBJECT
public:
	AppendFileDlg(const QString &startDir, const QString &filter, QWidget *parent, const char *name, bool modal);
	~AppendFileDlg();

	static KURL getOpenURL(const QString &startDir = QString::null, QWidget *parent = 0);

public slots:
	void slotGoCt();
	void slotGoIx();

private:
	KConfig *config;
	KAction *goCt, *goIx;
};


class AppendDlg: public KDialog
{
	Q_OBJECT
public:
	AppendDlg(QWidget *parent = 0, const char *name = 0);
	virtual ~AppendDlg();

	bool appendFile(const QString &filename);

private slots:
	void slotHelp();
	void slotAppend();

	void slotCopyResult(KIO::Job *job);
	void slotUnzipExited(KProcess *proc);
	
private:
	void scanEntries();
	void purgeDir();

	QString m_filename;
	KIO::FileCopyJob *m_copyjob;
	KProcess *m_unzipproc;

	QLabel *ct_first, *ct_last, *ct_editions, *ct_articles;
	QLabel *ix_first, *ix_last, *ix_editions, *ix_articles;

	KPushButton *bappend;
};


#endif // APPENDDLG_H
