// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */



#ifndef __KDETVXV_PLUGIN_H
#define __KDETVXV_PLUGIN_H

#include <qwidget.h>
#include <kdetvsrcplugin.h>
#include <kxv.h>

class QTimer;

/**
 * Video source plugin for Xv
 */
class KdetvXv : public KdetvSourcePlugin
{
    Q_OBJECT

public:
    KdetvXv(Kdetv *ktv, QWidget *parent = 0, const char* name = 0);
    virtual ~KdetvXv();

    /**
     * To get various values.
     */
    virtual int brightness();
    virtual int colour();
    virtual int hue();
    virtual int contrast();
    virtual int whiteness();
    virtual int frequency();
    virtual bool muted();
    virtual bool isTuner();
    virtual int signal();
    virtual QColor colourKey();

    virtual const QStringList& broadcastedAudioModes();
    virtual const QString&     defaultAudioMode();

    virtual int probeDevices();

    virtual bool videoPlaying() const;

public slots:
    /**
     * Sets the device to use.
     */
    virtual int setDevice( const QString &dev );

    /**
     * Sets the source to use.
     */
    virtual int setSource( const QString &src );

    /**
     * Sets the encoding.
     */
    virtual int setEncoding( const QString &encoding );

    /**
     * Sets the current current channel.
     */
    virtual void setFrequency( int freq );

    /**
     * Mutes the sound.
     */
    virtual void setMuted( bool muted );

    int setAudioMode( const QString& audioMode );
    
    virtual void setBrightness(int val);
    virtual void setColour(int val);
    virtual void setHue(int val);
    virtual void setContrast(int val);
    virtual void setWhiteness(int val);

    virtual void viewResized();

    virtual int startVideo();
    virtual int stopVideo();
    
    virtual int setVideoDesktop(bool on);
    virtual bool canVideoDesktop() const;

    virtual void setFullscreen(bool fs);

    virtual bool canGrabStill() const;
    virtual bool grabStill( QImage *pix );

private:
    int  doSetEncoding( const QString &encoding, const QString &source );
    void parseXvEncoding( const QString &xvEncoding, QString &source, QString &encoding );

    QTimer *resizeTimer;

public:
    KXv *xvHandle;
    KXvDevice *xvDevice;
};

#endif

