#include <qlabel.h>
#include <qpushbutton.h>
#include <qscrollview.h>
#include <qtimer.h>
#include <qvbox.h>

#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <klocale.h>
#include <kpopupmenu.h>

#include "elegant.h"

static KCmdLineOptions options[] =
{
  { 0, 0, 0 }
};

int main( int argc, char *argv[] )
{
  KAboutData aboutData( "test_elegant", I18N_NOOP( "test_elegant" ),
			"test_elegant 0.1", 
			I18N_NOOP( "Command-line tool for testing Elegant." ),
			KAboutData::License_LGPL,
			"(C) 2002 Richard Moore (rich@kde.org)" );
  aboutData.addAuthor( "Richard Moore", 0, "rich@kde.org" );

  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

  KApplication app;
//  KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
  QObject::connect( &app, SIGNAL(lastWindowClosed()), &app, SLOT(quit()) );

  // Main window
  QVBox *vbox = new QVBox( 0, "test_elegant" );
  vbox->setMargin(8);
  vbox->setSpacing(6);

  KPopupTitle *ttl = new KPopupTitle( vbox );
  ttl->setText( QString("Elegant Plugin Test Program") );

  QHBox *main = new QHBox( vbox );
  main->setSpacing(6);

  // Test screen
  QScrollView *screen = new QScrollView( main );
  screen->setSizePolicy( QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding) );
  QtVisionElegant *el = new QtVisionElegant( screen, "test_elegant" );

  QTimer *timer = new QTimer( screen );
  QObject::connect( timer, SIGNAL( timeout() ), el, SLOT( updateGeometry() ) );
  timer->start( 200 );

  // Test commands
  QVBox *box = new QVBox( main );
  box->setSizePolicy( QSizePolicy(QSizePolicy::Fixed,QSizePolicy::Expanding) );
  box->setSpacing(6);

  (new QWidget(box))->setSizePolicy( QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding) );

  QPushButton *pb = new QPushButton( QString("&Channel Popup"), box );
  QObject::connect( pb, SIGNAL( clicked() ), el, SLOT( test_channel() ) );
  pb = new QPushButton( QString("&Mute Popup"), box );
  QObject::connect( pb, SIGNAL( clicked() ), el, SLOT( test_mute() ) );
  pb = new QPushButton( QString("&Volume Popup"), box );
  QObject::connect( pb, SIGNAL( clicked() ), el, SLOT( test_volume() ) );

  (new QWidget(box))->setSizePolicy( QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding) );

  // Close button
  main = new QHBox( vbox );
  main->setSpacing(6);

  (new QWidget(main))->setSizePolicy( QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Fixed) );

  pb = new QPushButton( QString("&Configure..."), main );
  QObject::connect( pb, SIGNAL( clicked() ), el, SLOT( test_config() ) );

  pb = new QPushButton( QString("Close"), main );
  QObject::connect( pb, SIGNAL( clicked() ), &app, SLOT( quit() ) );

  // Run it
  vbox->resize( 600, 400 );
  vbox->show();

  el->display( QString("Elegant Tester") );

  return app.exec();
}
