// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef CHANNELIOXML_H
#define CHANNELIOXML_H

#include <qdom.h>

#include "kdetvchannelplugin.h"

/**
 * Implements the XML channel format.
 *
 * @version $Id: channelioxml.h,v 1.7 2004/03/23 22:00:22 dziegel Exp $
 * @author Richard Moore, rich@kde.org
 */
class ChannelIOFormatXML : public KdetvChannelPlugin
{
public:
    ChannelIOFormatXML(Kdetv *ktv, QObject *parent, const char* name);
    virtual ~ChannelIOFormatXML() {}

    virtual bool load( ChannelStore *store, QIODevice *file, const QString& fmt );
    virtual bool save( ChannelStore *store, QIODevice *file, const QString& fmt );
    virtual KdetvChannelPlugin::ChannelFileMetaInfo getMetaInfo( QIODevice *file, const QString& fmt );

    QDomDocument document() const { return doc; }

    bool readDocument( ChannelStore *store );
    void writeDocument( ChannelStore *store );

protected:
    // Read helpers
    Channel *readChannel( const QDomElement &elem );
    QString readText( const QDomElement &elem, const QString &tag );
    int readTextInt( const QDomElement &elem, const QString &tag );
    unsigned long readTextULong( const QDomElement &parent, const QString &tag );
    bool readAttrBool(const QDomElement &elem, const QString &name);

    // Write helpers
    QDomElement writeChannel( QDomElement &parent, Channel *ch );
    QDomElement writeText( QDomElement &parent, const QString &tag, const QString &text );
    QDomElement writeTextInt( QDomElement &parent, const QString &tag, int text );
    QDomElement writeTextULong( QDomElement &parent, const QString &tag, unsigned long text );
    QDomElement writeElement( QDomNode &parent, const QString &tag );
    void writeAttrBool(QDomElement &parent, const QString &name, const bool val);

private:
    QDomDocument doc;
    ChannelStore *store;
};

#endif // CHANNELIOXML_H

