// -*- c++ -*-
/***************************************************************************
                           channelpropertiesdialogimpl.cpp
                           -------------------------------
    begin                : Sat Apr 10 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <kdebug.h>
#include <klocale.h>
#include <knuminput.h>

#include <qcheckbox.h>
#include <qstring.h>
#include <qcombobox.h>
#include <qlcdnumber.h>
#include <qlineedit.h>

#include "channel.h"
#include "channelpropertiesdialogimpl.h"
#include "kdetv.h"
#include "sourcemanager.h"


ChannelPropertiesDialogImpl::ChannelPropertiesDialogImpl( Channel* channel,
                                                          SourceManager* srcm,
                                                          QWidget* parent, 
                                                          const char* name,
                                                          bool modal,
                                                          WFlags fl )
    : ChannelPropertiesDialog(parent, name, modal, fl),
      _c(channel),
      _srcm(srcm)
{
    _enabled->setChecked(_c->enabled());
    _number->display(_c->number());
    _name->setText(_c->name());
    _freq->setValue(double(_c->freq())/1000);

    // add sources to listbox
    _source->insertStringList(_srcm->sourcesFor(_srcm->device()));
    // select current source
    for (int i = 0; i < _source->count(); i++) {
        if (_c->source() == _source->text(i)) {
            _source->setCurrentItem(i);
            break;
        }
    }

    // add norms to listbox
    _encoding->insertStringList(_srcm->encodingsFor(_srcm->device()));
    // select current norm
    for (int i = 0; i < _encoding->count(); i++) {
        if (_c->encoding() == _encoding->text(i)) {
            _encoding->setCurrentItem(i);
            break;
        }
    }

    connect(_freq, SIGNAL( valueChanged(double) ),
            this,  SLOT( freqChanged(double) ));
    connect(_source, SIGNAL( activated(const QString&) ),
            _srcm,   SLOT( setSource(const QString&) ));
    connect(_encoding, SIGNAL( activated(const QString&) ),
            _srcm,     SLOT( setEncoding(const QString&) ));
}

ChannelPropertiesDialogImpl::~ChannelPropertiesDialogImpl()
{
}

void ChannelPropertiesDialogImpl::freqChanged(double f)
{
    _srcm->setFrequency((long)(f*1000));
}

void ChannelPropertiesDialogImpl::freqUp()
{
    _freq->setValue( QMIN(_freq->value()+0.25, 1000.0) );
}

void ChannelPropertiesDialogImpl::freqDown()
{
    _freq->setValue( QMAX(_freq->value()-0.25, 0.0) );
}

void ChannelPropertiesDialogImpl::accept()
{
    _c->updateValues( _name->text(),
                      _c->number(),
                      (long)(_freq->value()*1000),
                      _enabled->isChecked(),
                      _encoding->currentText(),
                      _source->currentText() );
    QDialog::accept();
    emit accepted();
}

void ChannelPropertiesDialogImpl::reject()
{
    QDialog::reject();
    emit rejected();
}

#include "channelpropertiesdialogimpl.moc"
