// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifndef _CHANNEL_H
#define _CHANNEL_H

#include <qobject.h>
#include <qstring.h>
#include "kdetvchanneliface.h"

/**
 * Defines a TV channel.
 */
class Channel : public QObject, public KdetvChannelIface
{
    Q_OBJECT
    Q_PROPERTY( int number READ number WRITE setNumber )
    Q_PROPERTY( ulong freq READ freq WRITE setFreq )
    Q_PROPERTY( QString name READ name WRITE setName )
    Q_PROPERTY( QString source READ source WRITE setSource )
    Q_PROPERTY( QString encoding READ encoding WRITE setEncoding )
    Q_PROPERTY( bool enabled READ enabled WRITE setEnabled )

public:
    Channel( QObject *parent, const char *name=0 );
    virtual ~Channel() {}

    int number() const { return _num; }
    ulong freq() const { return _freq; }
    bool enabled() const { return _enabled; }
    QString name() const { return _name; }
    QString source() const { return _source; }
    QString encoding() const { return _encoding; }

    void setValues( const Channel *src );
    void updateValues( const QString& name, int num, unsigned long freq, bool enabled, QString encoding, QString source );

public slots:
    void setNumber( int num );
    void setFreq( ulong freq );
    void setEnabled( bool enabled = true );
    void setName( const QString &name );
    void setSource( const QString &source );
    void setEncoding( const QString &encoding );

signals:
    void changed(); 

private:
    QString _name;
    int _num;
    ulong _freq;
    bool _enabled;
    QString _source;
    QString _encoding;
};

#endif
