/*
 *
 * Copyright (C) 2003 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#include "v4lutil.h"
#include <stdlib.h>

#ifdef __STRICT_ANSI__
#define FOO__STRICT_ANSI__
#undef __STRICT_ANSI__
#endif
#include <asm/types.h>
#ifdef FOO__STRICT_ANSI__
#define __STRICT_ANSI__
#undef FOO__STRICT_ANSI__
#endif
#define _LINUX_TIME_H
#define _DEVICE_H_
#include <linux/videodev.h>

#include <qimage.h>
#include <kdebug.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>

int V4LUtil::V4LBppForFormat(int fmt)
{
	switch (fmt) {
	case VIDEO_PALETTE_RGB32:
	case VIDEO_PALETTE_RGB24:
		return 4;
	case VIDEO_PALETTE_RGB555:
	case VIDEO_PALETTE_RGB565:
	case VIDEO_PALETTE_YUV422:
	case VIDEO_PALETTE_YUYV:
	case VIDEO_PALETTE_UYVY:
	case VIDEO_PALETTE_YUV420:
	case VIDEO_PALETTE_YUV411:
	case VIDEO_PALETTE_YUV422P:
	case VIDEO_PALETTE_YUV411P:
	case VIDEO_PALETTE_YUV420P:
	case VIDEO_PALETTE_YUV410P:
		return 2;
	case VIDEO_PALETTE_GREY:
		return 1;
	case VIDEO_PALETTE_HI240:
	case VIDEO_PALETTE_RAW:
	default:
		// unknown format
		return -1;
	}
}


bool V4LUtil::findDisplayProperties(int& palette, int& depth, int& bitsperpixel, int& bytesperpixel)
{
    XVisualInfo *vi_in, vi_out;
    long mask = VisualScreenMask;
    int  nvis = 0;

    int p   = -1;
    int bpp = -1;
    int d   = -1;
    
	vi_out.screen = QPaintDevice::x11AppScreen();
	vi_in         = XGetVisualInfo(qt_xdisplay(), mask, &vi_out, &nvis);

	if (vi_in) {
		for (int i = 0; i < nvis; i++) {
            bpp = -1;
			int n;
			XPixmapFormatValues *pf = XListPixmapFormats(qt_xdisplay(),&n);
            d = vi_in[i].depth;
			for (int j = 0; j < n; j++) {
				if (pf[j].depth == d) {
					bpp = pf[j].bits_per_pixel;
					break;
				}
			}
			XFree(pf);
            
            p = -1;
			switch (bpp) {
			case 32:
				if (vi_in[i].red_mask   == 0xff0000 &&
				    vi_in[i].green_mask == 0x00ff00 &&
				    vi_in[i].blue_mask  == 0x0000ff) {
					p = VIDEO_PALETTE_RGB32;
					kdDebug() << "Found RGB32 display." << endl;
				}
                break;
			case 24:
				if (vi_in[i].red_mask   == 0xff0000 &&
				    vi_in[i].green_mask == 0x00ff00 &&
				    vi_in[i].blue_mask  == 0x0000ff) {
					p = VIDEO_PALETTE_RGB24;
					kdDebug() << "Found RGB24 display." << endl;
				}
                break;
			case 16:
				if (vi_in[i].red_mask   == 0x00f800 &&
				    vi_in[i].green_mask == 0x0007e0 &&
				    vi_in[i].blue_mask  == 0x00001f) {
					p = VIDEO_PALETTE_RGB565;
					kdDebug() << "Found RGB565 display." << endl;
				} else   // is this correct?
                    if (vi_in[i].red_mask   == 0x007c00 &&
                        vi_in[i].green_mask == 0x0003e0 &&
                        vi_in[i].blue_mask  == 0x00001f) {
                        p = VIDEO_PALETTE_RGB555;
                        kdDebug() << "Found RGB555 display." << endl;
                    }
                break;
			case 8:
			default:
				continue;
			}

			if (p != -1)
				break;
		}
		XFree(vi_in);
	}
    
    if (p != -1) {
        int bytespp = V4LBppForFormat(p);        
        kdDebug() << "Display properties: depth: " << d
                  << ", bits/pixel: " << bpp
                  << ", bytes/pixel: " << bytespp << endl;
        palette       = p;
        bitsperpixel  = bpp;
        bytesperpixel = bytespp;
        depth         = d;
        return true;
    } else {
        kdDebug() << "Unable to find out palette. What display do you have????" << endl;
        palette       = -1;
        bitsperpixel  = -1;
        bytesperpixel = -1;
        depth         = -1;
        return false;
    }
}
