#!/bin/bash


#  slackbuild script for kipi-plugins
# Author: Mark Tucker
# Created: Jul 31, 2004
# Changes:
#        Jul 31, 2004 - initial creation
#        Oct 24, 2004 - updated for ver. 0.1 beta1
#        Apr 1, 2005 - updated for ver. 0.1.0 beta2
#        Sep 18, 2005 - updated to use sbuild.functions file
#
#----------------------------------------------------------------------
umask 0022

#----------------------------------------
# include the common functions
#----------------------------------------
if [ -r ./sbuild.functions ]; then
    . ./sbuild.functions
else
    echo Cannot read file `pwd`/sbuild.functions
    echo Exiting....
    echo
    exit
fi

#----------------------------------------
# Set locations for temp directories
#----------------------------------------
# location of source code archive
srcdir=`pwd`/SRC
workdir=`pwd`


#----------------------------------------
# Package variables
#----------------------------------------
source="kipi-plugins-0.1.0-beta2.tar.bz2"
pkgname="kipi_plugins"
pkgver="0.1.0_beta2"
release="1mht"
package="$pkgname-$pkgver-i486-$release.tgz"
realname="Mark Tucker"
echo Package: $package

#----------------------------------------
# setup path variables
#----------------------------------------
set_workdir
builddir="kipi-plugins-0.1.0-beta2"

# unpack the source
echo Unpacking the source...
tar -xjf $srcdir/$source


cd $builddir

#----------------------------------------
# setup the build environment
#----------------------------------------
export CFLAGS="-O2 -march=i486 -mcpu=i686"
export CPPFLAGS="-O2 -march=i486 -mcpu=i686"
export CXXFLAGS=$CPPFLAGS



#----------------------------------------
# Build the package and install
#----------------------------------------
# configure 
conf_opts="--prefix=/opt/kde"
#    > $workdir/config.output 2>&1
run_configure $conf_opts

# make
run_make

# Set target directory
set_target

# install
run_makeinstall


echo finishing install...


# create install dir
mkdir $target/install

#----------------------------------------
# create slack-desc file to install
#----------------------------------------
cat > $target/install/slack-desc << END
            |-----handy-ruler---------------------------------------------------
---|
$pkgname: $pkgname $pkgver
$pkgname:
$pkgname: Libkipi allows image applications to use a plugin architecture for
$pkgname: additional functionality. 17 plugins included.  (These were
$pkgname: also know as the Digikam Plugins.)
$pkgname:
$pkgname:
$pkgname:
$pkgname: http://gwenview.sourceforge.net/
$pkgname:
$pkgname: Packaged by $realname for $slackver / KDE 3.4.2
END

# create documentation directory
create_docdir

# fix group on bin directories.
fix_bingrp

# strip  bin files
strip_bin

# strip lib files
strip_libs

# check for uncompressed man pages
compr_man

# makepkg
create_pkg

exit