/*****************f**********************************************************
                          kwappen.cpp  -  description
                             -------------------
    begin                : Sam Okt 20 14:11:56 CEST 2001
    copyright            : (C) 2001 by Jens Schulz
    email                : jschulz-lcs@t-online.de / cce@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwappen.h"

const int BILDH = 680;
const int BILDBR = 640;

extern Kwappen* topW;
extern Highscore *highS;
extern HighscoreEdit *highE;
extern Heraldry* herald;

extern QString data_path;
extern QString home_path;

QImage background;

Kwappen::Kwappen()
{
  start = 0;     // paint event flag
  sekunden = 0;  // seconds
  found = 0;     // search flag
  swap = 0;      // computer stone swapflag
  status = -1;   // working level
  reversecolumn = 0;  // reverse column no.

  loadOptions(); // load options.txt

  setGeometry(100, 40, BILDBR, BILDH);  // window set
  setMinimumSize(BILDBR, BILDH);
  setMaximumSize(BILDBR, BILDH);
  setBackgroundMode(NoBackground);

  bgroup = new QButtonGroup(NULL,NULL);
  rotatebutton1 = new QPushButton("1",this);
  bgroup->insert(rotatebutton1);
  rotatebutton2 = new QPushButton("2",this);
  bgroup->insert(rotatebutton2);
  rotatebutton3 = new QPushButton("3",this);
  bgroup->insert(rotatebutton3);
  rotatebutton4 = new QPushButton("4",this);
  bgroup->insert(rotatebutton4);
  connect(bgroup, SIGNAL(clicked(int)),SLOT(rotateColumns(int)));
  swapbutton = new QPushButton(i18n("Swap stone 1x"),this);         // swap button
  connect(swapbutton, SIGNAL(clicked()),SLOT(swapComp()));
  timer = new QTimer(this);             // timer set
  connect(timer, SIGNAL(timeout()),SLOT(countSeconds()));
  timer->start(500,false);             // 500ms interval
}

int Kwappen::random_color()            // random color select for stones
{
  int z;
  z = rand() % 16;
  if (z < 0) z *= -1;
  z++;
  return z;
}

int Kwappen::random_column()           // random column select
{
  int z;                               // for computer stone
  z = rand() % 4;
  if (z < 0) z *= -1;
  return z;
}

void Kwappen::set_random()             // set random generator
{
  int i = 0, random = 0;               // use system time
  time_t zeit;
  time(&zeit);
  strcpy(zeitstr,ctime(&zeit));
  while(zeitstr[i])
  {
    random += (zeitstr[i]*i);
    i++;
  }
  srand(random);
}

void Kwappen::eatblank()               // eat spaces (string)
{
  int i = 0, j = 0;
  while(zeitstr[i])
  {
    if (zeitstr[i] != ' ')
    {
      zeitstr[j++] = zeitstr[i];
    }
    i++;
  }
  zeitstr[j] = 0;
}

void Kwappen::start_turm()
{
  int reihe, spalte;
  swap = 0;                                  // clear computer stone swapflag
  swapbutton->setText(i18n("Swap stone 1x")); 
  swapbutton->setEnabled(true);
  do                                         // loop avoids rows with same card color
  {
    for(spalte = 0; spalte <= 3; spalte++)   // clear columns
    {
      for(reihe = 0; reihe <= 11 ; reihe++)
      {
        turm[reihe][spalte] = 0;
      }
    }
    for (spalte = 0; spalte <= 3; spalte++)  // create the 4 columns
    {
      turm_farbe(spalte);
    }
    found = 0;
    vier_shrink();                           // four row test
  }while(found);
  stein1 = random_color();                   // computer arms
  sekunden = 0;                              // second counter to 0
  timer->start(500,false);                   // start timer (500 ms interval)
}

void Kwappen::draw_turmset()                 // move selected stone
{
  int i = 0, j = 0;
  char farbe;
  farbe = turm[stein1old][stein2old];
  turm[stein1old][stein2old] = -1;
  for (i=0; i<=11; i++)                      // shrink column
  {
    if (turm[i][stein2old] != -1)
    {
      turm[j][stein2old] = turm[i][stein2old];
      j++;
     }
  }
  i = 0;
  while (turm[i][steiny] > 0) i++;           // move stone on column top
  turm[i][steiny] = farbe;
  own_row = i; own_col = steiny; own_color = farbe;
}

void Kwappen::set_computer()                 // add computer stone on column top
{
  int i;
  i = 0;
  while (turm[i][spalte1] > 0) i++;
  turm[i][spalte1] = stein1;
  comp_row = i; comp_col = spalte1; comp_color = stein1;
  stein1 = 0;
}

void Kwappen::vier_shrink()                  // four row shrink
{
  int reihe;
  char tcheck1, tcheck2;
  for(reihe = 0; reihe <= 11; reihe++)
  {
    if (turm[reihe][0] > 0 && turm[reihe][1] > 0 && turm[reihe][2] > 0 && turm[reihe][3] > 0 )
    {
      tcheck1 = turm[reihe][1] % 4;
      if (turm[reihe][0] % 4 == tcheck1)
      {
        tcheck2 = turm[reihe][2] % 4;
        if (tcheck1 == tcheck2)
        {
          if (tcheck2 == turm[reihe][3] % 4)
          {
            turmcpy[reihe][0] = -1;          // clear row
            turmcpy[reihe][1] = -1;
            turmcpy[reihe][2] = -1;
            turmcpy[reihe][3] = -1;
            found = 1;
          }
        }
      }
    }
    else
    {
      return;
    }
  }
}

void Kwappen::column_shrink()                // column shrink
{
  int reihe, spalte;
  char farbe1, farbe2;
  for(spalte = 0;  spalte <= 3; spalte++)
  {
    for(reihe = 0; reihe <= 10; reihe++)
    {
      if (turm[reihe][spalte] > 0)
      {
         farbe1 = turm[reihe][spalte];
         farbe2 = turm[reihe+1][spalte];
         if (farbe1 == farbe2)
         {
           turmcpy[reihe][spalte] = -1;
           turmcpy[reihe+1][spalte] = -1;
           found = 1;
         }
      }
      else
      {
        break;
      }
    }
  }
}

void Kwappen::turm_copy()
{
   int reihe, spalte;
   for(spalte = 0; spalte <= 3; spalte++)     // copy columns
   {
     for(reihe = 0; reihe <= 11 ; reihe++)
     {
       turmcpy[reihe][spalte] = turm[reihe][spalte];
     }
   }
}

void Kwappen::turm_shrinking()               // shrink columns
{
  int j, reihe, spalte;
  for(spalte = 0; spalte <= 3; spalte++)
  {
    j = 0;
    for(reihe = 0; reihe <= 11 ; reihe++)
    {
      if (turmcpy[reihe][spalte] != -1)
      {
        turm[j][spalte] = turmcpy[reihe][spalte];
        j++;
      }
    }
  }
}

void Kwappen::turm_reduce()                      // tower shrink algorithm
{
  do
  {
    found = 0;
    turm_copy();                                 // copy tower
    vier_shrink();                               // four row shrink
    column_shrink();                             // column shrink
    turm_shrinking();                            // shrink tower
  }while(found);
  status = 7;
  repaint();
}

void Kwappen::turm_reverse(int spalte)           // reverse column
{
  int i, j = 0;
  for (i=0; i<=10; i++)
  {
    turmcpy[10-i][spalte] = turm[i][spalte];
  }
  for (i=0; i<=10; i++)
  {
    if (turmcpy[i][spalte] > 0)
    {
      turm[j][spalte] = turmcpy[i][spalte]; j++;
    }
  }
}

void Kwappen::turm_farbe(int spalte)           // create new tower
{
  int i, tempzufall;
  turm[0][spalte] = random_color();             // color arms
  for(i=1; i<=5; i++)
  {
    tempzufall = random_color();
    while (tempzufall == turm[i-1][spalte])
    {
      tempzufall = random_color();
    }
    turm[i][spalte] = tempzufall;
  }
}

void Kwappen::ende_check()                       // end checking
{
  int j, reihe, spalte;
  char win_or_lose = 0;
  for(spalte = 0;  spalte <= 3; spalte++)
  {
    j = 0;
    for(reihe = 0; reihe <= 11; reihe++)
    {
      if (turm[reihe][spalte] > 0)  j++;
      else break;
    }
    if (j > 9 )
    {
      win_or_lose = -1;
      status = 8;  break;
    }
  }
  if (win_or_lose == 0)
  {
    if (turm[1][0] == 0 && turm[1][1] == 0 && turm[1][2] == 0 && turm[1][3] == 0)
    {
       win_or_lose = 1;
       status = 9;
    }
  }
  if (win_or_lose == 0)
  {
    stein1 = random_color();
    status = -1;
  }
  repaint();
}

void Kwappen::setTextBox(QPainter *p)   // set graphic text (rules)
{
  static QColor beige (250,245,137);
  p->setBrush(beige);
  p->drawRect(450,40,180,30);
  p->setPen(Qt::black);
  p->setFont(QFont("courier", 14, QFont::Bold));
  p->drawText(460,250,200,30, Qt::AlignLeft,i18n("Shrink rules:"));
  p->setFont(QFont("courier", 12, QFont::Bold));
  p->drawText(457,42,200,30, Qt::AlignLeft, i18n("Next computer set"));
  p->drawText(460,270,200,30, Qt::AlignLeft,i18n("4x same card"));
  p->drawText(460,290,200,30, Qt::AlignLeft,i18n("color in a row"));
  p->drawImage(460,310, picture, 55,20,20,20);
  p->drawImage(482,308, picture, 135,20,20,20);
  p->drawImage(512,308, picture, 215,20,20,20);
  p->drawImage(537,308, picture, 290,20,20,20);
  p->drawText(460,330,200,30, Qt::AlignLeft,i18n("Rule 2:"));
  p->drawText(460,350,200,30, Qt::AlignLeft,i18n("2 equal stones"));
  p->drawText(460,370,200,30, Qt::AlignLeft,i18n("in a column"));
  p->drawLine(450,390,629,390);
  p->drawText(460,400,200,30, Qt::AlignLeft,i18n("You win :"));
  p->drawText(460,420,200,30, Qt::AlignLeft,i18n("All columns have"));
  p->drawText(460,440,200,30, Qt::AlignLeft,i18n("1 or 0 stones"));
  p->drawLine(450,460,629,460);
  p->drawText(460,470,200,30, Qt::AlignLeft,i18n("You lose :"));
  p->drawText(460,490,200,30, Qt::AlignLeft,i18n("One column has"));
  p->drawText(460,510,200,30, Qt::AlignLeft,i18n("10 stones after"));
  p->drawText(460,530,200,30, Qt::AlignLeft,i18n("shrinking"));
  p->drawLine(450,560,629,560);
  p->drawText(460,570,200,30, Qt::AlignLeft,i18n("Button 1 - 4"));
  p->drawText(460,590,200,30, Qt::AlignLeft,i18n("Reverse a column"));
  p->drawText(460,610,200,30, Qt::AlignLeft,i18n("and shrink"));
}

void Kwappen::paintEvent(QPaintEvent*)              // paint event
{
  QPainter p;
  int reihe, spalte, pos;
  QPointArray arrow(4);

  static QColor beige (250,245,137);
  p.begin(&buffer);
  if (start == 0)                                   // init graphics
  {
    start = 1;
    highS->loadHighscore();
    picture.load(data_path+"wappen.png",0);         // load stone pictures
    background.load(data_path+"background.jpg",0);  // load background
    p.drawImage(0, 0, background, 0, 0, 640, 680);
    p.setPen(Qt::black);
    p.setBrush(beige);
    p.drawRect(450,40,180,600);
    setTextBox(&p);                                 // draw graphic text
    start_turm();                                   // build start columns
  }
  p.setBrush(beige);
  p.drawRect(450,69,180,171);
  p.drawLine(450,150,630,150);
  for(spalte = 0;  spalte <= 3; spalte++)
  {
    for(reihe = 0; reihe <= 11; reihe++)
    {
      if (turm[reihe][spalte] > 0)                  // draw stones
      {
        p.drawImage(20+spalte*110, 580-reihe*59, picture, (turm[reihe][spalte] - 1)*79, 0, 79, 59);
      }
      else                                          // clean column
      {
        p.drawImage(20+spalte*110, 47, background, 20+spalte*110, 47, 79, (11-reihe)*59-57);
        break;
      }
    }
  }
  p.drawImage(500, 80, picture, (stein1-1)*79, 129, 79, 59);  // draw computer stone
  p.setFont(QFont("courier", 24, QFont::Bold));
  p.setPen(Qt::darkBlue);
  sprintf(zeitstr,"TIME:%5u",sekunden/2);                     // show time
  eatblank();
  p.drawText(458,205,180,30, Qt::AlignLeft, zeitstr);
  p.setPen(Qt::black);
  p.drawLine(450,200,630,200);
  p.drawLine(450,239,629,239);
  if (status == -1)                                  // start new move
  {
    spalte1 = random_column();                       // random column for computer
    p.drawImage(0, 20, background, 0, 20, 440, 27);
    arrow.setPoint(0,40+spalte1*110,26);             // draw arrow
    arrow.setPoint(1,60+spalte1*110,46);
    arrow.setPoint(2,80+spalte1*110,26);
    p.drawPolygon(arrow,false,0,3);
    status = 0;
  }

  switch(status)                                           // status = game mode
  {
    case 0: p.setPen(Qt::red);
            p.setFont(QFont("courier", 12, QFont::Bold));
            p.drawText(455,155,200,30, Qt::AlignLeft, i18n("Select one stone"));
            p.drawText(455,175,200,30, Qt::AlignLeft, i18n("in the 4 columns"));
            break;
    case 1: p.setPen(Qt::red);                             // select column for own stone
            p.setFont(QFont("courier", 12, QFont::Bold));
            p.drawText(455,155,200,30, Qt::AlignLeft, i18n("Select a column"));
            p.drawText(455,175,200,30, Qt::AlignLeft, i18n("for stone move"));
            p.drawImage(20+steiny*110, 579-steinx*59, picture, (turm[steinx][steiny] - 1)*79, 64, 79, 59);
            break;
    case 2: draw_turmset();                         // set own stone on column top
            set_computer();                         // set computer stone on random column
            if (! auto_sh_delay) turm_reduce();     // reduce columns (autoshrink delay off)
            else
            {
              status = 4;
              repaint();    // don't wait on timer (no recursive overflow)
            }
            break;
    case 3: turm_reverse(reversecolumn);            // reverse column
            set_computer();
            if (! auto_sh_delay) turm_reduce();
            else
            {
              status = 5;
              repaint();    // don't wait on timer (no recursive overflow)
            }
            break;
    case 4: setCursor(waitCursor);                  // autoshrink delay, standard move
            p.drawRect(500,80,79,59);
            p.drawImage(20+own_col*110, 579-own_row*59, picture, (own_color-1)*79, 64, 79, 59);
            p.drawImage(20+comp_col*110, 579-comp_row*59, picture, (comp_color-1)*79, 129, 79, 59);
            break;
    case 5: setCursor(waitCursor);
            p.drawRect(500,80,79,59);               // autoshrink delay, reverse column
            p.drawImage(20+comp_col*110, 579-comp_row*59, picture, (comp_color-1)*79, 129, 79, 59);
            break;
    case 6: setCursor(arrowCursor);                // autoshrink delay, column reduce
            turm_reduce(); break;
    case 7: swap = 0;
            swapbutton->setText(i18n("Swap stone 1x"));  // end check
            swapbutton->setEnabled(true);
            ende_check(); break;
    case 8: status = 10;                           // you lose
            break;
    case 9: status = 11;                           // you win
            break;
   case 10: timer->stop();
            status = -1;
            QMessageBox::information(0,"Kwappen","The game is over\nYou lose, sorry !");
            start_turm();
            break;
   case 11: timer->stop();                 // stop timer
            sekunden--;
            highE->sec = sekunden / 2;
            pos = highS->testHighscore();  // check highscore entry
            if (pos != -1)
            {
              highE->position = pos;
              status = 12;
              highE->show();
            }
            else
            {
               QMessageBox::information(0,"Kwappen",i18n("You win, yeah !"));
               status = -1;
               start_turm();
            }
  }
  p.end();
  bitBlt(this, 0, 0, &buffer);              // copy graphic buffer to screen
}

void Kwappen::mousePressEvent(QMouseEvent* e)          // mouse handling
{ int x, y;
  QPoint clickedPos = e->pos();                        // extract pointer position
  x = clickedPos.x();  y = clickedPos.y();
  steinx = 0; steiny = 0;
  if (x >= 20 && x <= 639 && y >= 10 && y <= 639)      // check stone position
  { if (x <= 100) steiny = 0;
    else if ((x >= 130) && (x <= 210)) steiny = 1;     // determine column no.
    else if ((x >= 240) && (x <= 320)) steiny = 2;
    else if ((x >= 350) && (x <= 430)) steiny = 3;
    else
    {
      steinx = stein1old;
      steiny = stein2old;
      return;
    }
    if (status == 1)                                   // column marked
    {
       if (e->button() == RightButton)  status = 0;    // disable selected stone
       else status = 2;
       repaint();
       return;
    }
    steinx = (639 - y) / 59;
    if (turm[steinx][steiny] == 0)                     // no stone found
    {
      return;
    }
    if (status == 0)
    {
      status = 1;
      stein1old = steinx;
      stein2old = steiny;
    }
  }
  repaint(0, 0, BILDBR, BILDH, FALSE);
}

void Kwappen::resizeEvent(QResizeEvent* event)        // resize event
{
  rotatebutton1->setGeometry(20,647,80,24);
  rotatebutton2->setGeometry(130,647,80,24);
  rotatebutton3->setGeometry(240,647,80,24);
  rotatebutton4->setGeometry(350,647,80,24);
  swapbutton->setGeometry(450,647,180,24);
  buffer.resize(event->size());
}

void Kwappen::keyPressEvent(QKeyEvent* e)
{
  switch(e->key())
  { case Qt::Key_1: rotateColumns(0); break;
    case Qt::Key_2: rotateColumns(1); break;
    case Qt::Key_3: rotateColumns(2); break;
    case Qt::Key_4: rotateColumns(3); break;
  }
  repaint(0, 0, BILDBR, BILDH, FALSE); }

void Kwappen::newGame()                               // start new game
{
  start_turm();
  status = -1;
}

void Kwappen::autoShrink()                            // set autoshrink delay
{ if (auto_sh_delay)
  {
    auto_sh_delay = 0;
    options->setItemChecked(autoshitem,FALSE);
  }
  else
  {
    auto_sh_delay = 1;
    options->setItemChecked(autoshitem,TRUE);
  }
}

void Kwappen::saveOptions()                          // save options
{
  FILE* stream;
  stream = fopen(home_path+"kwappen_options.txt", "wt");
  if (! stream)  return;
  if (auto_sh_delay) fputs("1\n", stream);
  else fputs("0\n", stream);
  fclose(stream);
}

void Kwappen::heraldry()                            // heraldry show
{
  herald->show();
}

void Kwappen::loadOptions()                         // load options
{
  char tempstr[20];
  FILE* stream;
  stream = fopen(home_path+"kwappen/kwappen_options.txt", "rt");
  if (! stream)
  {  // create new kwappen directory for user
     mkdir(home_path+"kwappen",S_IRWXU|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH);
     stream = fopen(home_path+"kwappen/kwappen_options.txt", "wt");           // create options.txt
     fputs("1\n", stream);  // default autoshrink delay on
     auto_sh_delay = 1;
  }
  else
  {
     fgets(tempstr, 20, stream);
     auto_sh_delay = atoi(tempstr);
  }
  fclose(stream);
}

void Kwappen::countSeconds()                       // timer slot
{
  sekunden++;
  if (status == 4 || status == 5) status = 6;      // autoshrink delay
  repaint();
}

void Kwappen::swapComp()                           // swap computer stone (max. 1x)
{
  char old_stein;
  old_stein = stein1;
  if (status <= 2 && swap == 0)
  {
    stein1 = random_color();
    while (stein1 == old_stein)                   // avoid same computer stone
    {
      stein1 = random_color();
    }
    swap = 1;
    swapbutton->setText(i18n("disabled"));        // disable swap button
    swapbutton->setEnabled(false);                // button grey
    repaint(); return;
  }
}

void Kwappen::rotateColumns(int i)              // revert column
{
  if (status <= 1)
  {
     reversecolumn = i;
     status = 3;
     repaint();
  }
}

void Kwappen::showHighscore()              // show highscore
{
  highS->lookHighscore();
  repaint();
}

void Kwappen::clearHighscore()             // clear highscore
{
  FILE* stream;
  int i;
  QMessageBox *mb = NULL;
  mb = new QMessageBox(i18n("Clear highscore table ?"),
              i18n("Are you sure ?"),
              QMessageBox::Information,
              QMessageBox::No | QMessageBox::Default,
              QMessageBox::Yes, QMessageBox::Cancel, this);
  if (mb->exec() == QMessageBox::Yes)
  {
    stream = fopen(home_path+"kwappen/kwappen_highscore.txt", "wt");
    if (! stream)  return;
    for(i=0;i<=49;i++)
    {
      fputs("XXX : ---\n", stream);
      highS->score[i] = 99999;
    }
    fclose(stream);
  }
  repaint();
}

void Highscore::loadHighscore()              // load highscore
{
  FILE* stream;
  int i;
  char tempstr[60];
  stream = fopen(home_path+"kwappen/kwappen_highscore.txt", "rt");
  if (! stream)
  { for(i=0;i<=49;i++) score[i] = 99999;
    stream = fopen(home_path+"kwappen/kwappen_highscore.txt", "wt");  // new highscore table
    if (! stream)  return;
    for(i=0;i<=49;i++)
    {
      fputs("XXX : ---\n", stream);
      highS->score[i] = 99999;
    }
    fclose(stream);
    return;
  }
  for(i=0;i<=49;i++)
  {
    fgets(tempstr, 60, stream);
    if (strcmp(tempstr,"XXX : ---\n") == 0) score[i] = 99999;
    else score[i] = atoi(tempstr);
  }
  fclose(stream);
  repaint();
}

void Highscore::paintEvent(QPaintEvent*)      // highscore paint event
{
  QPainter p;
  char i;
  char tempstr[60];
  char tempstr1[60];
  FILE* stream;
  p.begin(this);
  p.setFont(QFont("courier", 12, QFont::Normal));
  p.drawImage(0,0,background, 0,0,270,500);
  listBox->clear();
  stream = fopen(home_path+"kwappen/kwappen_highscore.txt", "rt");
  for(i=0;i<=49;i++)
  {
    fgets(tempstr, 60, stream);
    if (strcmp(tempstr,"XXX : ---\n") != 0)
    {
      if (strlen(tempstr))
      {
        tempstr[strlen(tempstr)-1] = 0;  // LF delete
      }
      sprintf(tempstr1, "%2u. %s", i+1, tempstr);
    }
    else
    {
      sprintf(tempstr1, "%2u. ------------------", i+1);
    }
    listBox->insertItem(tempstr1);
  }
  p.end();
}

void Highscore::lookHighscore()   // display highscore dialog
{
  highS->show();
}

void Highscore::closeHighscore()  // hide highscore dialog
{
   highS->hide();
}

char Highscore::testHighscore()    // test new highscore entry
{
  int i, zeit;
  zeit = highE->sec;
  loadHighscore();
  for (i = 0; i <= 49; i++)
  {
    if (zeit < score[i])
    {
      highE->rank = i + 1;
      return i;
    }
  }
  return -1;
}

void HighscoreEdit::writeHighscore()  // write highscore file
{
  int i, zeit;
  FILE* stream;
  char tempstr[50];
  char playn[50][50];
  zeit = sec;
  stream = fopen(home_path+"kwappen/kwappen_highscore.txt", "rt");
  if (! stream)  return;
  for(i = 0; i < 50; i++)          // read player names from file
  {
    fgets(tempstr, 50, stream);
    strcpy(playn[i], tempstr);
  }
  fclose(stream);
  stream = fopen(home_path+"kwappen/kwappen_highscore.txt", "wt");
  if (! stream)  return;
  for(i = 0; i < position; i++)             // write highscore file
  {
    fputs(playn[i], stream);
  }
  sprintf(tempstr,"%5u : %s\n", zeit, playerName);
  fputs(tempstr,stream);
  for(i = position + 1; i < 50; i++)
  { if (highS->score[i-1] == 99999)
    {
      fputs("XXX : ---\n", stream);
    }
    else
    {
      sprintf(tempstr,"%s", playn[i-1]);
      fputs(tempstr,stream);
    }
  }
  fclose(stream);
  stream = fopen(home_path+"kwappen/kwappen_highscore_name.txt", "wt");  // new highscore table
  if (stream)
  {
    fputs(playerName, stream);
    fclose(stream);
  }
}

Highscore::Highscore(QWidget* parent, const char* name, WFlags f) : QDialog(parent, name, TRUE, f)
{
  setGeometry(200, 100, 270, 500);
  setMinimumSize(270, 500);           // highscore dialog constructor
  setMaximumSize(270, 500);
  setBackgroundMode(NoBackground);
  setCaption("Highscore Kwappen");
  okButton = new QPushButton(" Okay ",this);
  okButton->setGeometry(100,460,80,30);
  connect(okButton, SIGNAL(clicked()),SLOT(closeHighscore()));
  listBox = new QListBox(this);
  listBox->setGeometry(10,10,250,440);
  okButton->setFocus();
}

void HighscoreEdit::paintEvent(QPaintEvent*)      // highscore paint event
{
  QPainter p;
  char tempstr[50];
  char tempstr1[50];
  char rankstr[50];
  p.begin(this);
  p.setFont(QFont("courier", 14, QFont::Normal));
  p.setBackgroundColor(Qt::white);
  p.setBrush(Qt::lightGray);
  p.drawRect(0,0,270,300);
  sprintf(tempstr,"%5d\n", sec);
  strcpy(tempstr1,"Highscore = ");
  sprintf(rankstr,"Highscore position: %2u\n",rank);
  p.drawText(10,20,260,30, Qt::AlignLeft, rankstr);
  strcat(tempstr1,tempstr);
  p.drawText(10,50,260,30, Qt::AlignLeft, tempstr1);
  p.drawText(10,80,260,30, Qt::AlignLeft, i18n("Enter your name :"));
  highscoreentry->setFocus();
  highscoreentry->setText(playerName);
  p.end();
}

void HighscoreEdit::getHighscore()   // input name highscore of player
{
  strcpy(playerName, highscoreentry->text());
  highE->hide();
  writeHighscore();
  topW->status = -1;
  topW->start_turm();
  topW->repaint();
}

HighscoreEdit::HighscoreEdit(QWidget* parent, const char* name, WFlags f) : QDialog(parent, name, TRUE, f)
{
  FILE* stream;
  setGeometry(200, 250, 270, 300);
  setMinimumSize(270, 200);           // highscore dialog constructor
  setMaximumSize(270, 200);
  setBackgroundMode(NoBackground);
  setCaption("Highscore");
  highButton = new QPushButton(" Okay ",this);
  highButton->setGeometry(100,160,80,30);
  highscoreentry = new QLineEdit(this);
  highscoreentry->setGeometry(10,120,250,30);
  highscoreentry->setFont(QFont("courier", 14, QFont::Normal));
  stream = fopen(home_path+"kwappen/kwappen_highscore_name.txt", "rt");
  if (! stream)
  { stream = fopen(home_path+"kwappen/kwappen_highscore_name.txt", "wt");  // new highscore table
    if (stream)
    {
      fputs("Noname", stream);
      strcpy(playerName,"Noname");
      fclose(stream);
    }
  }
  else
  {
     fgets(playerName, 20, stream);
     fclose(stream);
  }
  connect(highButton, SIGNAL(clicked()),SLOT(getHighscore()));
  connect(highscoreentry, SIGNAL(returnPressed()),SLOT(getHighscore()));
}

Heraldry::Heraldry(QWidget* parent, const char* name, WFlags f) : QDialog(parent, name, TRUE, f)
{
  setGeometry(205, 150, 240, 500);
  setMinimumSize(240, 500);           // highscore dialog constructor
  setMaximumSize(240, 500);
  setBackgroundMode(NoBackground);
  setCaption(i18n("Heraldry"));
  heraldryButton = new QPushButton(" Okay ",this);
  heraldryButton->setGeometry(80,460,80,30);
  connect(heraldryButton, SIGNAL(clicked()),SLOT(closeHeraldry()));
  heraldryButton->setFocus();
  heraldryListBox = new QListBox(this);
  heraldryListBox->setGeometry(10,10,220,440);
  heraldryListBox->insertItem(QPixmap(data_path+"baden_wuerttemberg.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"bayern.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"berlin.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"brandenburg.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"bremen.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"hamburg.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"hessen.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"mecklenburg_vorpommern.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"niedersachsen.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"nordrhein_westfalen.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"rheinland_pfalz.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"saarland.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"sachsen.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"sachsen_anhalt.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"schleswig_holstein.jpg"));
  heraldryListBox->insertItem(QPixmap(data_path+"thueringen.jpg"));
}

void Heraldry::paintEvent(QPaintEvent*)      // heraldry paint event
{
  QPainter p;
  p.begin(this);
  p.setFont(QFont("courier", 12, QFont::Normal));
  p.drawImage(0,0,background, 0,0,300,500);
  p.end();
}

void Heraldry::closeHeraldry()
{
  herald->hide();
}

void Kwappen::topWA(KApplication* app)                  // menu entries
{
  menu = new KMenuBar(topW);
  datei = new KPopupMenu();
  menu->insertItem(i18n("Game  "), datei);
  datei->insertItem(i18n("New game"), topW, SLOT(newGame()), Qt::CTRL + Qt::Key_N);
  datei->insertSeparator();
  datei->insertItem(i18n("Show highscore"), topW, SLOT(showHighscore()), Qt::CTRL + Qt::Key_H);
  datei->insertSeparator();
  datei->insertItem(i18n("Clear highscore"), topW, SLOT(clearHighscore()), Qt::ALT + Qt::Key_C);
  datei->insertSeparator();
  datei->insertItem(i18n("Quit"), app, SLOT(quit()), Qt::CTRL + Qt::Key_Q);
  options = new KPopupMenu();
  menu->insertItem(i18n("Options  "), options);
  autoshitem = options->insertItem(i18n("Autoshrink delay"), topW, SLOT(autoShrink()), Qt::CTRL + Qt::Key_A);
  options->insertSeparator();
  options->insertItem(i18n("Save options"), topW, SLOT(saveOptions()), Qt::CTRL + Qt::Key_S);
  options->insertSeparator();
  options->insertItem(i18n("Swap stone 1x"), topW, SLOT(swapComp()), Qt::Key_Space);
  options->insertSeparator();
  options->insertItem(i18n("Heraldry"), topW, SLOT(heraldry()), Qt::CTRL + Qt::Key_H);

  KPopupMenu *help = helpMenu(QString(i18n("KWappen"))
           + " " + VERSION
           + "\n\nWritten by Jens Schulz 2003  GPL2"
           + "\n(jschulz-lcs@t-online.de)"
           + "\n\nhttp://www.lcs-chemie.de");

  if (auto_sh_delay) options->setItemChecked(autoshitem,TRUE);
  else options->setItemChecked(autoshitem,FALSE);
  menu->insertItem(i18n("Help  "), help);
  menu->show();
}
