#include <qapplication.h>
#include <qsqldatabase.h>
#include <qsqlquery.h>
#include <qsqlcursor.h>

int main (int argc, char **argv)
{
	QApplication app(argc,argv);
	app.addLibraryPath(".");
	QSqlDatabase *db=QSqlDatabase::addDatabase("sqlite");
	if (db)
	{
		db->setDatabaseName("mibase");
		if (db->open())
		{
			printf ("database opened!\n");
			//Create a table
			QSqlQuery query ("create table tabla (name,surname,salary);",db);
			//now store some data in it
			for (int i=0;i<10;i++)
			{
				QString q;
				q.sprintf("insert into tabla values ('Joe','Doe',%d);",i*100);
				query.exec(q);
			}

			QSqlCursor cur("tabla",true,db);
            		cur.select(); // We'll retrieve every record
			qDebug ("got %d results",cur.size());
	                while ( cur.next() ) 
			{
			      qDebug( cur.value( "name" ).toString() + ": " +
			              cur.value( "surname" ).toString() + ": " +
			              cur.value( "salary" ).toString() );
						            }
		}
		else
		{
			printf ("can not open database\n");
		}
	}
}
