#ifndef rcsid
static const char rcsid[]="$Id: scriptsplit.cpp,v 2.4 2003/02/04 00:08:53 ral Exp $";
#endif

#ifdef _WIN32
#pragma warning ( disable : 4786 )
#endif

#include "scriptsplit.h"
#include "stdio.h"

CScriptSplit::CScriptSplit(stringlist*target,std::string*input)
{
    target_list = target;
    input_string=input;
}

CScriptSplit::~CScriptSplit()
{

}

int CScriptSplit::convert()
{
    if (!target_list || !input_string)
	return 0;

    remove_lastspaces();
    remove_comments();
    remove_empty_lines();
    convert_tabs();
    remove_spaces();
    make_lines();
    return 1;
}

int CScriptSplit::remove_empty_lines()
{
    size_t pos;
    pos = input_string->find("\n\n");
    while (pos != std::string::npos) {
	input_string->erase(pos,1);
	pos = input_string->find("\n\n");
    }
    return 1;
}

int CScriptSplit::convert_tabs()
{
    size_t pos;
    pos = input_string->find("\t");
    while (pos != std::string::npos) {
#ifndef _WIN32
        input_string->replace(pos,4," ");
#else
        input_string->replace(pos,pos,4,' ');
#endif
        pos = input_string->find("\t");
    }
    return 1;
}

int CScriptSplit::remove_comments()
{
    size_t pos,pos2;
    unsigned brace_count = 0;
    unsigned quote_count = 0;

    pos = input_string->find("/*");
    while (pos != std::string::npos) {
	pos2 = input_string->find("*/",pos);
	if (pos2 == std::string::npos) {
	    pos2 = input_string->size()-1;
	}
	input_string->erase(pos,pos2+2-pos);
	pos = input_string->find("/*");
    }
    for (pos = 0; pos < input_string->size();++pos) {
	if (input_string->data()[pos]==';' && brace_count == 0) {
	    pos2 = input_string->find("\n",pos);
	    if (pos2 == std::string::npos) {
		pos2 = input_string->size();
	    }
	    if (pos2 > pos+1) {
		--pos2;
		if (pos2 > pos) {
		    input_string->erase(pos+1,pos2-pos);
		}
	    }
	    continue;
	}
	if (input_string->data()[pos]=='\'' || input_string->data()[pos]=='\"') {
	    if (pos > 1) {
		if (input_string->data()[pos] == '\\')
		    continue;
	    }
	    quote_count = !quote_count;
	}
	if (input_string->data()[pos]=='(' && !quote_count) {
	    ++brace_count;
	    continue;
	}
	if (input_string->data()[pos]==')' && !quote_count) {
	    --brace_count;
	}
    }
    return 1;
}

int CScriptSplit::remove_spaces()
{
    //    size_t pos = input_string->size()-1;

    /*
      size_t pos = input_string->find("  ");
      while (pos != std::string::npos) {
      input_string->erase(pos,1);
      pos = input_string->find("  ");
      }*/

    return 1;
}

int CScriptSplit::remove_lastspaces()
{
    size_t pos = input_string->find(" \n");
    while (pos != std::string::npos) {
	input_string->erase(pos,1);
	pos = input_string->find(" \n");
    }
    return 1;
}

int CScriptSplit::make_lines()
{
    std::string _temp_string = "";
    size_t pos2 = 0;
    size_t pos = input_string->find(";\n",pos2);
    while (pos != std::string::npos) {
	_temp_string = "";
	_temp_string.assign(*input_string,pos2,pos-pos2);
	pos2 = pos+2;
	target_list->push_back(_temp_string);
	pos = input_string->find(";\n",pos2);
    }
    ++pos2;
    if (pos2 < input_string->size()-1) {
	pos = input_string->find_first_of(";",pos2);
	--pos2;
	if (pos == std::string::npos)
	    pos = input_string->size();
	_temp_string.assign(*input_string,pos2,pos-pos2);
	if (_temp_string[_temp_string.size()-1] == '\n')
	    _temp_string.erase(_temp_string.size()-1,1);
	target_list->push_back(_temp_string);
    }
    return 1;
}
