// -*- Mode: C++; -*-
#include "PatternPair.h"
#include "kmysqladmin/helpers/stringlist.h"

// $Id: e_patternpair.h,v 2.2 2003/02/04 00:08:53 ral Exp $

#ifndef e_pattern_included
#define e_pattern_included

class e_patternpair:virtual public CPatternPair
{

protected:
    stringIlist enums;
    void init(){enums.resize(0);}

public:
    e_patternpair(const char*Entry,const char*Pattern):CPatternPair(Entry,Pattern){init();}
    e_patternpair(const std::string&Entry,const std::string&Pattern):CPatternPair(Entry,Pattern){init();}
    e_patternpair():CPatternPair(){init();}
    e_patternpair(const CPatternPair&old):CPatternPair(old){init();}
    e_patternpair(const e_patternpair&old){copy_old(old);enums=old.enums;}

    e_patternpair&operator=(const e_patternpair&old){copy_old(old);enums=old.enums;return *this;}
 
    e_patternpair&operator=(const CPatternPair&old){copy_old(old);init();return *this;}

    void set_enumlist(const stringIlist& n_enums){enums = n_enums;}
    const stringIlist&enum_list()const{return enums;}

    const int operator<(const e_patternpair&old)const;
    const int operator==(const e_patternpair&old)const;
};

inline const int e_patternpair::operator <(const e_patternpair&old)const
{
    return pattern<old.pattern;
}

inline const int e_patternpair::operator==(const e_patternpair&old)const
{
    return pattern==old.pattern;
}


typedef std::vector<e_patternpair> e_PatternList;

//class e_PatternList:virtual public PatternList{};

typedef e_PatternList::iterator e_PatternIterator;
typedef e_PatternList::const_iterator Ce_PatternIterator;

#endif
