/*
 * KMLOFax
 *
 * A utility to process facsimiles received with a modem of the
 * ELSA MicroLink(tm) Office family.
 *
 * Copyright (C) 1999,2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen, Germany.
 */

#include <stdlib.h>
#include <string.h>

#include <qlayout.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qsize.h>
#include <qtooltip.h>
#include <qdir.h>
#include <qframe.h>

#include <kapplication.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kseparator.h>

#include "exportdlg.h"
#include "mlofile.h"
#include "filters.h"
#include "global.h"




ExportDlg::ExportDlg(QWidget *parent, const char *name): KDialog (parent, name, true)
{
	QBoxLayout *vbox, *hbox, *fvbox, *fhbox;
	QGroupBox *gb;
	QPushButton *help, *ok, *cancel;
	QLabel *l1, *l2;
	QSize size;
	KSeparator *separator;

	config = kapp->config();

	vbox = new QVBoxLayout(this , marginHint());

	gb = new QGroupBox(i18n("Export to File"), this);
	fvbox = new QVBoxLayout(gb, 12);
	fvbox->addSpacing(8);
	fhbox = new QHBoxLayout();
	fvbox->addLayout(fhbox);
	file = new QLineEdit(gb);
	file->setMinimumWidth(240);
	file->setFixedHeight(file->sizeHint().height());
	file->setText(QDir::currentDirPath() + "/facsimile.tif");
	fhbox->addWidget(file);

	browse = new QPushButton(gb);
	browse->setAutoDefault(false);
	browse->setPixmap(SmallIcon("fileopen"));
	browse->setFixedSize(browse->sizeHint()+QSize(4, 4));	
	fhbox->addWidget(browse);
	
	fvbox->activate();

	vbox->addWidget(gb);
		
	gb = new QGroupBox(i18n("Options"), this);
	fvbox = new QVBoxLayout(gb, 12);
	fvbox->addSpacing(8);
	fhbox = new QHBoxLayout();
	fvbox->addLayout(fhbox);
	l1 = new QLabel(i18n("&From page:"), gb);
	fhbox->addWidget(l1);
	from_page = new QSpinBox(1, 999, 1, gb);
	l1->setBuddy(from_page);
	from_page->setValue(1);
	from_page->setFixedWidth(from_page->sizeHint().width());
	from_page->setFixedHeight(from_page->sizeHint().height());
	fhbox->addWidget(from_page);
	fhbox->addStretch(1);
	fhbox = new QHBoxLayout();
	fvbox->addLayout(fhbox);
	l2 = new QLabel(i18n("&To page:"), gb);
	fhbox->addWidget(l2);
	to_page = new QSpinBox(1, 999, 1, gb);
	l2->setBuddy(to_page);
	to_page->setValue(999);
	to_page->setFixedWidth(to_page->sizeHint().width());
	to_page->setFixedHeight(to_page->sizeHint().height());
	fhbox->addWidget(to_page);
	fhbox->addStretch(1);
	
	size = l1->sizeHint().expandedTo(l2->sizeHint());
	l1->setMinimumSize(size);
	l2->setMinimumSize(size);

	separator = new KSeparator(KSeparator::HLine, gb);
	fvbox->addWidget(separator, 1);
	
	fhbox = new QHBoxLayout();
	fvbox->addLayout(fhbox);
	
	l1 = new QLabel(i18n("&Compression:"), gb);
	l1->setMinimumSize(l1->sizeHint());
	l1->setFixedHeight(l1->sizeHint().height());
	fhbox->addWidget(l1);

	compression = new QComboBox(false, gb);
	l1->setBuddy(compression);
	compression->insertItem(i18n(" CCITT Group 3 "), 0);
//	compression->insertItem(i18n(" None "), 1);
	compression->setMinimumSize(compression->sizeHint());
	fhbox->addWidget(compression);
	fhbox->addStretch(1);
	
	fvbox->activate();
	
	vbox->addWidget(gb);
	
	hbox = new QHBoxLayout(8);
	vbox->addLayout(hbox);

	help = new QPushButton(i18n("&Help"), this);
	ok = new QPushButton(i18n("&OK"), this);
	ok->setDefault(true);
	cancel = new QPushButton(i18n("&Cancel"), this);
	size = help->sizeHint().expandedTo(ok->sizeHint().expandedTo(cancel->sizeHint()));

	help->setFixedSize(size);
	ok->setFixedSize(size);
	cancel->setFixedSize(size);

	hbox->addWidget(help);
	hbox->addStretch();
	hbox->addWidget(ok);
	hbox->addWidget(cancel);

	vbox->activate();

	config->setGroup(ID_PREF_GROUP_GENERAL);
	if (config->readBoolEntry(ID_PREF_GEN_TOOLTIPS, PREF_GEN_TOOLTIPS)) {
		QToolTip::add(file, i18n("Name of file to export to"));
		QToolTip::add(browse, i18n("Select file to export to"));
		QToolTip::add(from_page, i18n("First page to export"));
		QToolTip::add(to_page, i18n("Last page to export"));
		QToolTip::add(compression, i18n("Compression method for TIFF file"));
	}

	connect(browse, SIGNAL(clicked()), SLOT(slotBrowse()));
	connect(help, SIGNAL(clicked()), SLOT(slotHelp()));
	connect(ok, SIGNAL(clicked()), SLOT(slotOk()));
	connect(cancel, SIGNAL(clicked()), SLOT(reject()));

	setCaption(i18n("Export"));
}


ExportDlg::~ExportDlg()
{
}


void ExportDlg::exportFax(const QString &name)
{
	TiffFile mlofile;

	mlofile.setName(expandPath(name));

	if (!mlofile.open(IO_ReadOnly)) {
		KMessageBox::sorry(this, i18n("Cannot open facsimile file."), i18n("File Error"));
		return;
	}

	from_page->setRange(1, mlofile.pages());
	from_page->setValue(1);
	to_page->setRange(1, mlofile.pages());
	to_page->setValue(mlofile.pages());
	mlofile.close();

	m_name = name;
}


void ExportDlg::slotBrowse()
{
	QString s = file->text();

	if (s.isEmpty())
		s = QDir::currentDirPath();

	s = KFileDialog::getSaveFileName(s, i18n("*.tif|TIFF Files (*.tif)\n*|All Files (*)"), this);
	if (!s.isEmpty())
		file->setText(s);
}


void ExportDlg::slotHelp()
{
	kapp->invokeHelp("export-help");
}


void ExportDlg::slotOk()
{
	Tiff2TiffFilter filter;

	filter.setFile(expandPath(m_name));
	filter.setRange(from_page->value(), to_page->value());
//	filter.setCompression(compression->currentItem());

	kapp->setOverrideCursor(waitCursor);

	filter.convertFile(file->text());

	kapp->restoreOverrideCursor();

	accept();
}
