/*
 * KMLOCfg
 *
 * A utility to configure modems of the ELSA MicroLink(tm) Office family.
 *
 * Copyright (C) 2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen, Germany.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <kstandarddirs.h>
#include <klocale.h>
#include <kglobal.h>

#include "global.h"


QString expandPath(const QString& fname)
{
	return locateLocal("appdata", fname);
}


NumberValidator::NumberValidator(QWidget *parent, const char *name): QValidator(parent, name)
{
}


NumberValidator::~NumberValidator()
{
}

	
QValidator::State NumberValidator::validate(QString &input, int &) const
{
	uint i;

	for (i=0; i < input.length(); i++) {
		if (!input[i].isDigit())
			return QValidator::Invalid;
	}
	
	return QValidator::Acceptable;
}



FaxIDValidator::FaxIDValidator(QWidget *parent, const char *name): QValidator(parent, name)
{
}


FaxIDValidator::~FaxIDValidator()
{
}

	
QValidator::State FaxIDValidator::validate(QString &input, int &) const
{
	uint i;

	for (i=0; i < input.length(); i++) {
// According to Table 3/T.30:
//		if (!(input[i].isDigit() || (input[i] == '+') || (input[i] == ' ')))
// All printable ASCII:
		if ((input[i] < 32) || (input[i] > 127) || (input[i] == '"'))
			return QValidator::Invalid;
	}
	
	return QValidator::Acceptable;
}
