// Emacs-Mode: -*-C++-*-
/***************************************************************************
                          mainwidget.h  -  description
                             -------------------
    begin                : Sam Apr 6 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.5 $
    date                 : $Date: 2002/04/14 09:24:11 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _MAINWIDGET_H_
#define _MAINWIDGET_H_

#include <qwidget.h>
#include <qptrvector.h>
#include <qptrlist.h>


// Forward declarations
class QTabWidget;
class KURL;
class KActionCollection;
class LogBook;
class Dive;



/**MainWidget of KDiveMaster
  *@author Martin Habbecke
  */

class MainWidget : public QWidget  {
    
    Q_OBJECT

public: 
   
    //! Default Constructor
    MainWidget( QWidget *parent = 0, const char *name = 0);
    
    //! Default Destructor
    ~MainWidget();

    //! Function that obens the logbooks of the last session
    void openLastLogBooks( void );

    //! Function to set the KActionCollection of the TopWindow to enable the MainWidget to enable / disable actions
    void setActionCollection( KActionCollection *actionCollection );

    //! Function that enables / disables all actions according to the current state of the program
    void updateActionState( void );


public slots:
    //! Slot that is called whenever the selection in a LogBookWidget changes
    void slotSelectionChanged( int numberOfSelectedDives );

    //! Slot that creates a new LogBook
    void slotFileNew( void );

    //! Slot that opens an existing LogBook
    void slotFileOpen( void );

    //! Slot for opening a recent file
    void slotFileOpenRecent( const KURL& );

    //! Slot that saves an existing LogBook
    void slotFileSave( void );
    
    //! Slot that saves a LogBook to a new file
    void slotFileSaveAs( void );


    //! Slat that opens a logbook from a given URL
    void slotFileOpenUrl( const KURL &openURL );

    //! Slot that saves the current selected LogBook to saveURL
    void slotFileSaveUrl( const KURL &saveURL );


    //! Slot to close a LogBook
    void slotFileClose( void );

    //! Slot to import dives fram an aladin computer
    void slotImportAladin( void );


    //! Slot to edit the name of a LogBook
    void slotEditLogbookName( void );

    //! Slot to delete the currently selected dives int the current logbook
    void slotEditCutDives( void );

    //! Slot to copy currently selected dives into local buffer
    void slotEditCopyDives( void );

    //! Slot to paste dives from local buffer to current logbook
    void slotEditPasteDives( void );

    
    //! Slot that is called when the current tab of the QTabWidget changes
    void slotCurrentTabChanged( QWidget *page );



signals:
    //! Signal to carry a filename to the list of recent files
    void signalNewRecentFile( const KURL & );


private:

    //! Function to create the GUI
    void setupGui( void );

    //! QTabWidget to display LogBookWidgets
    QTabWidget *_tabWidget;

    //! Vector of open LogBooks
    QPtrVector< LogBook > *_openLogBooks;

    //! List of copied dives
    QPtrList< Dive > *_diveClipboard;

    //! Pointer to the KActionCollection of the TopWindow
    KActionCollection *_actionCollection;
};

#endif // _MAINWIDGET_H_
