// Emacs-Mode: -*-C++-*-
/***************************************************************************
                          logbook.h  -  description
                             -------------------
    begin                : Son Apr 7 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
    version              : $Revision: 1.5 $
    date                 : $Date: 2002/04/13 18:26:56 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _LOGBOOK_H_
#define _LOGBOOK_H_

#include <qptrlist.h>
#include <qstring.h>

#include <kurl.h>

#include "dive.h"


//! Abstraction of a whole logbook
/*! Class to abstract a whole logbook as a list of dives
 
  \author Martin Habbecke
*/
class LogBook : public QPtrList<Dive> {

public: 
    //! Default Constructor
    LogBook();

    //! Constructor that sets the name
    LogBook( const QString &name );

    //! Default Destructor
    ~LogBook();

    //! Function to delete a dive by its number
    void deleteDive( int number );

    //! Function to get a pointer to a dive by its number
    Dive const *getDive( int number );

    //! Access to the name of the logbook
    inline QString name( void ) const;

    //! Access to the filename of the logbook
    inline KURL url( void ) const;


    //! Function to set the name of the logbook
    inline void setName( const QString &name );

    //! Function to set the filename of the logbook
    inline void setUrl( const KURL &url );


protected:
    //! Function to compare two dives by theire date and time
    virtual int compareItems ( QPtrCollection::Item item1, QPtrCollection::Item item2 );

    //! Name of this logbook
    QString _name;

    //! Filename where this logbook has been loaded from / saved to
    KURL _url;
};



inline QString LogBook::name( void ) const
{ return _name; }

inline KURL LogBook::url( void ) const
{ return _url; }



inline void LogBook::setName( const QString &name )
{ _name = name; }

inline void LogBook::setUrl( const KURL &url )
{ _url = url; }


#endif // _LOGBOOK_H_
