/***************************************************************************
                          kdivemaster.cpp  -  description
                             -------------------
    begin                : Sam Apr  6 11:25:35 CEST 2002
    copyright            : (C) 2002 by Martin Habbecke
    email                : M.Habbecke@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>

#include "kaction.h"
#include "kmenubar.h"
#include "kpopupmenu.h"
#include "klocale.h"
#include "kstdaccel.h"
#include "kapplication.h"
#include "kedittoolbar.h"
#include "kkeydialog.h"
#include "kurl.h"
#include "kconfig.h"


#include "mainwidget.h"
#include "kdivemaster.h"


KDiveMaster::KDiveMaster(QWidget *parent, const char *name) 
    : KMainWindow(parent, name)
{
    setupGui();
    setupActions();

    _mainWidget->setActionCollection( actionCollection() );

    setAutoSaveSettings();
}


KDiveMaster::~KDiveMaster()
{
    _recentAction->saveEntries( kapp->config() );
    saveMainWindowSettings( kapp->config(), "MainWindow" );
}


/***********************************************
 ***********************************************/




void KDiveMaster::slotConfigureToolbars( void )
{
    saveMainWindowSettings( KGlobal::config(), "MainWindow" );

    KEditToolbar dlg( actionCollection() );
    connect( &dlg, SIGNAL(newToolbarConfig()),
	     this, SLOT(slotNewToolbarConfig()) );

    if( dlg.exec() )
    {
	createGUI();
    }
}


void KDiveMaster::slotNewToolbarConfig( void )
{
    applyMainWindowSettings( kapp->config(), "MainWindow" );
}


void KDiveMaster::slotConfigureKeys( void )
{
    KKeyDialog::configure( actionCollection() );
}


void KDiveMaster::slotAddRecentFile( const KURL &url )
{
    _recentAction->addURL( url );
}

/***********************************************
 ***********************************************/



void KDiveMaster::setupGui( void )
{
    _mainWidget = new MainWidget( this );
    _mainWidget->setMinimumSize( _mainWidget->sizeHint() );
    setCentralWidget( _mainWidget );

    connect( _mainWidget, SIGNAL(signalNewRecentFile(const KURL &)),
	     this, SLOT(slotAddRecentFile(const KURL &)) );

}


void KDiveMaster::setupActions( void )
{
    KAction *dummy;

    dummy = new KAction( i18n( "&New Logbook" ), "filenew",
			 KStdAccel::shortcut( KStdAccel::New ),
			 _mainWidget, SLOT(slotFileNew()),
			 actionCollection(), "my_file_new");
    
    dummy = new KAction( i18n( "&Open Logbook" ), "fileopen",
			 KStdAccel::shortcut( KStdAccel::Open ),
			 _mainWidget, SLOT(slotFileOpen()),
			 actionCollection(), "my_file_open" );

    _recentAction = KStdAction::openRecent( _mainWidget, 
					    SLOT(slotFileOpenRecent(const KURL&)),
					    actionCollection(), 
					    "my_file_open_recent" );
    _recentAction->loadEntries( kapp->config() );

    dummy = new KAction( i18n( "Import from &Aladin..." ), "fileimport",
			 KStdAccel::shortcut( KStdAccel::AccelNone ),
			 _mainWidget, SLOT(slotImportAladin()),
			 actionCollection(), "my_file_import_aladin" );
    
    dummy = new KAction( i18n( "&Save Logbook" ), "filesave",
			 KStdAccel::shortcut( KStdAccel::Save ),
			 _mainWidget, SLOT(slotFileSave()),
			 actionCollection(), "my_file_save" );

    dummy = new KAction( i18n( "Save Logbook &As..." ), "filesaveas",
			 KShortcut(),
			 _mainWidget, SLOT(slotFileSaveAs()),
			 actionCollection(), "my_file_saveas" );

    dummy = new KAction( i18n( "&Close Logbook" ), "fileclose",
			 KStdAccel::shortcut( KStdAccel::Close ),
			 _mainWidget, SLOT(slotFileClose()),
			 actionCollection(), "my_file_close" );
    
    dummy = KStdAction::quit( kapp, SLOT(quit()),
			      actionCollection(), "my_file_quit" );


    dummy = new KAction( i18n( "Edit Logbook Name..." ), "edit",
			 KShortcut(),
			 _mainWidget, SLOT(slotEditLogbookName()),
			 actionCollection(), "my_edit_name" );

    dummy = new KAction( i18n( "Cut dives" ), "editcut",
			 KStdAccel::shortcut( KStdAccel::Cut ),
			 _mainWidget, SLOT(slotEditCutDives()),
			 actionCollection(), "my_edit_cut" );
    dummy->setEnabled( false );

    dummy = new KAction( i18n( "Copy dives" ), "editcopy",
			 KStdAccel::shortcut( KStdAccel::Copy ),
			 _mainWidget, SLOT(slotEditCopyDives()),
			 actionCollection(), "my_edit_copy" );
    dummy->setEnabled( false );    

    dummy = new KAction( i18n( "Paste dives" ), "editpaste",
			 KStdAccel::shortcut( KStdAccel::Paste ),
			 _mainWidget, SLOT(slotEditPasteDives()),
			 actionCollection(), "my_edit_paste" );


    dummy = KStdAction::configureToolbars( this,
					   SLOT(slotConfigureToolbars()),
					   actionCollection(),
					   "set_conf_toolbars" );
    
    dummy = KStdAction::keyBindings( this, SLOT(slotConfigureKeys()),
				     actionCollection(), "set_conf_keys" );

    createGUI();
}
