/*
 *   Copyright (C) 2003 Ole Behrmann <obehrmann@hbg-bremen.de>
 *   Christoph Thielecke <crissi99@gmx.de>
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 */


#ifndef UserAdmin_H
#define UserAdmin_H

#include <qwidget.h>
#include <qbuttongroup.h>
#include <qtoolbutton.h> 
#include <qevent.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qcheckbox.h>
#include <qlistview.h>
#include <qregexp.h>
#include <qradiobutton.h>
#include <qprocess.h>
#include <qstring.h>
#include <klocale.h>
#include <klineedit.h>
#include <kmessagebox.h>
#include <kpushbutton.h>
#include <ktempfile.h>
#include <kprocess.h>
#include <kpassdlg.h>
#include <kurlrequester.h>
#include <kcombobox.h>
#include <klistview.h>
#include <knuminput.h>
#include <klineeditdlg.h>
#include <kconfig.h>
#include <kmainwindow.h>

#include "useradminbase.h"
#include "useradminpref.h"
#include "useradminadd.h"
#include "useradminedit.h"


/**
 * @short UserAdmin base class
 * @author Ole Behrmann <obehrmann@hbg-bremen.de>
 * @author Christoph Thielecke <crissi99@gmx.de>
*/

class UserAdmin : public UserAdminBase  {
   Q_OBJECT
public:

     /**
     * Default Constructor
     */

	UserAdmin(QWidget *parent=0, const char *name=0);

     /**
     * Default Destructor
     */
	~UserAdmin();

  int NumberOfRows(int z);
  void initUserList();

  KListViewItem *itemErr;
  KListViewItem *itemFirst;


  // user add dialog
  UserAdminAdd *AddDialog;

  // user edit dialog
  UserAdminEdit *EditDialog;

  // preferences dialog
  UserAdminPref *PrefDialog;
  UserAdminPref *startPref;


QListViewItem *pCurrent;

QProcess *delUser;


public slots:

 void slotRefresh();
 void slotAddUser();
 void slotEditUser();
 void slotDelUser();
 void slotShowPref();
 void slotChPass();


private slots:
 void onListViewClicked(QListViewItem *);
 void configChanged();
 void showContextMenu(KListView *,QListViewItem* ,const QPoint &);
 void mouseDoubleClickEvent(QMouseEvent *e);

private:
 KConfig   *config;
 void loadConfig(); 
 QString boolToString(bool b);
 
 // global config variables
 QString urlSystemGroupFile;
 QString urlSystemPasswdFile;
 bool useSystemFilesPaths;
 bool usePureftpdFilesPaths;
 QString urlPureftpdPasswdFile;
 QString urlPureftpdGroupFile;
 QString urlPureftpdDatabaseFile;
 bool usePureftpdStandardFilePaths;    
 bool useNotifyStandard;
 bool notifyUserDel;
 bool notifyUserModify;
 bool notifyUserAdd;
 bool useCleanStandard;
 bool clearUserEdit;
 bool clearUserAdd;

};

#endif



