/*
 *   Copyright (C) 2003 Crissi <crissi99@gmx.de>
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 */


#include "currentuserinfo.h"
#include <qobject.h>
#include <qprocess.h>
#include <qmessagebox.h>
#include <klocale.h>



CurrentUserInfo::CurrentUserInfo(){
	username = "";
	groupname = "";
}

CurrentUserInfo::~CurrentUserInfo()
{
	
}


QString CurrentUserInfo::getCurrentUser(){
   slotGetUser();
   while(p1->isRunning())
      {}
   return username;
}

QString CurrentUserInfo::getCurrentGroup(){
   slotGetGroup();
   while(p2->isRunning())
      {}
   return groupname;
}

void CurrentUserInfo::readFromStdoutUser(){
	// Read and process the data.
 username = p1->readLineStdout();
}

void CurrentUserInfo::readFromStdoutGroup(){
	// Read and process the data.
	groupname = p2->readLineStdout();
}

void CurrentUserInfo::slotGetUser(){
	p1 = new QProcess();

	p1->addArgument( "id" );
   p1->addArgument( "-un" );
	

	if ( !p1->start() ) {
   
	QMessageBox::information (NULL,"info",i18n("currentUserInfo: getCurrentUser() failed!"));
		username="";
   }
	connect( p1, SIGNAL(readyReadStdout()), this, SLOT(readFromStdoutUser()) );

	
}

void CurrentUserInfo::slotGetGroup() {
	p2 = new QProcess();

	p2->addArgument( "id" );
   p2->addArgument( "-gn" );

	connect( p2, SIGNAL(readyReadStdout()), this, SLOT(readFromStdoutGroup()) );
		
   if ( !p2->start() ) {
		QMessageBox::information (NULL,"info",i18n("currentUserInfo: getCurrentGroup() failed!"));
		groupname="";
   }


}
