#!/bin/bash


find ../ -maxdepth 10 -name *.cpp > files
find ../ -maxdepth 10 -name *.h >> files
xgettext -o kpum.pot  -ki18n -ktr2i18n -kI18N_NOOP -k__tr -k__tr_no_lookup -k__tr2qs -k__tr2wc -k__tr2ws -x /opt/kde3/include/kde.pot -f files
rm files

langs=`ls *.po`
old=_old
for lang  in $langs
do
  echo "moving $lang to $lang$old..."
  mv $lang $lang$old
  echo "done!"
  echo "merging new strings..."
  msgmerge -o $lang $lang$old kpum.pot
  echo "done!"
  echo "deleting old file $lang$old..-"
  rm $lang$old
  echo "done!"
done
