/**
 * subsystem.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#include "subsystem.h"

#include "configurationview.h"
#include "progressmanager.h"
#include "kernel.h"

#include <klocale.h>
#include <kdebug.h>

using namespace KConfigEditor;

Subsystem::Subsystem( QObject *parent )
    : QObject( parent )
{
}

ProgressItem * Subsystem::progressItem() const
{
    if ( !m_progressItem ) {
        m_progressItem = ProgressManager::createProgressItem( 0,
                                                              protocol(),
                                                              i18n( "Subsystem Progress" ) );
    }
    return m_progressItem;
}

bool Subsystem::save()
{
    GroupToken *group = 0;
    bool saved = false;
    QDictIterator<GroupToken> itr( m_topLevelGroup );
    while ( ( group = itr.current() ) ) {
        if ( group->hasPendingChanges() ) {
            saved = true;
            saveConfig( group );
            group->prunePendingChanges(); //has been saved so make sure it's clear now
        }
        ++itr;
    }
    return saved;
}

void Subsystem::discard()
{
    GroupToken *group = 0;
    QDictIterator<GroupToken> itr( m_topLevelGroup );
    while ( ( group = itr.current() ) ) {
        if ( group->hasPendingChanges() )
            group->prunePendingChanges();
        ++itr;
    }
}

void Subsystem::restoreEntry( const KURL &item )
{
    QString path = item.path();

    QStringList paths = QStringList::split( "/", path );

    KURL url;
    url.setProtocol( protocol() );
    url.addPath( paths.front() );

    GroupToken *group = m_topLevelGroup[ url.path() ];
    if ( group ) {
        paths.pop_front();
        group->restoreToken( item, paths );
    }
    else
        kdWarning()<<"Serious error :: no group at \""<< url.path() <<"\""<<endl;
}

#include "subsystem.moc"
