/**
 * descriptionwidget.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#include "descriptionwidget.h"

#include "entrytoken.h"

#include <ksqueezedtextlabel.h>
#include <klocale.h>

#include <qtextedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qframe.h>

using namespace KConfigEditor;

DescriptionWidget::DescriptionWidget( QWidget *parent )
    : QWidget( parent )
{
    QBoxLayout *l = new QVBoxLayout( this );

    QBoxLayout *h = new QHBoxLayout( l );
    QLabel *label = new QLabel( i18n( "Short description:" ),
                                this );
    label->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Preferred );
    m_shortDescr = new KSqueezedTextLabel( i18n("(None)"), this );
    h->addWidget( label );
    h->addWidget( m_shortDescr );

    l->addSpacing( 10 );

    h = new QHBoxLayout( l );
    label = new QLabel( i18n( "Long description:" ),
                                this );
    label->setAlignment( Qt::AlignTop );
    m_longDescr = new QTextEdit( this );
    m_longDescr->setReadOnly( true );
    m_longDescr->setFrameStyle( QFrame::NoFrame );
    h->addWidget( label );
    h->addWidget( m_longDescr );
}


QString DescriptionWidget::shortDescr() const
{
    return m_shortDescr->text();
}

QString DescriptionWidget::longDescr() const
{
    return m_longDescr->text();
}

void DescriptionWidget::setShortDescr( const QString &text )
{
    m_shortDescr->setText( text );
}

void DescriptionWidget::setLongDescr( const QString &text )
{
    m_longDescr->setText( text );
}

void DescriptionWidget::setFromToken( EntryToken *token )
{
    QString shortDescr = token->label();
    QString longDescr  = token->whatsThis();

    if ( shortDescr.isEmpty() )
        shortDescr = i18n( "Not available" );
    if ( longDescr.isEmpty() )
        longDescr = i18n( "Not available" );

    m_shortDescr->setText( shortDescr );
    m_longDescr->setText( longDescr );
}

#include "descriptionwidget.moc"
