/**
 * kdescriptgenerator.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KDESCRIPTGENERATOR_H
#define KDESCRIPTGENERATOR_H

#include "interfaces/scriptgenerator.h"

#include <qstring.h>

namespace KConfigEditor
{
    class GroupToken;
    class KDEScriptGenerator : public ScriptGenerator
    {
    public:
        KDEScriptGenerator();
        virtual QString protocol() const { return "kde"; }

        virtual QString backupScript( const QDict<GroupToken> &topLevelGroups );
        virtual QString propagationScript( const QDict<GroupToken> &topLevelGroups );
        virtual QString fullBackupScript( const QDict<GroupToken> &topLevelGroups );
    protected:
        QString applicationBackup( GroupToken *token, bool propagation );
    };
}

#endif
