/**
 * token.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#ifndef KONFIG_TOKEN_H
#define KONFIG_TOKEN_H

#include <kurl.h>

#include <qstringlist.h>
#include <qptrlist.h>
#include <qvariant.h>
#include <qstring.h>

//Here are the elements that one can find
//in a config file.
namespace KCfgCreator
{
    class Token
    {
    public:
        /**
         * Creates the token with the given name
         */
        Token( const QString& name, bool readOnly = false );
        virtual ~Token();

        /**
         * Sets the name of this token, creates a Memento
         * user to undo this change and increments the modified
         * counter of this token.
         */
        virtual void setName( const QString& );
        virtual QString name() const;

        /**
         * Returns true if this token has been modified.
         */
        bool modified() const;

        void setReadOnly( bool );
        bool readOnly() const;

        void enableUndo();
        void disableUndo();
        bool undoEnabled() const;

        void setImmutable( bool b );
        bool immutable() const;

    protected:
        friend class Memento;
        /**
         * Memento pattern like. Adds undo action.
         */
        void addMemento();

        virtual Memento *createMemento();

        void incrementModificationCount();
        void decrementModificationCount();
    protected:
        class Private;
        Private *d;
    };
}

#endif
