/**
 * main.cpp
 *
 * Copyright (C)  2003  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include "creator.h"
#include "kernel.h"

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <kdebug.h>

using namespace KCfgCreator;

static KCmdLineOptions kconf_options[] =
{
    { "+file", I18N_NOOP("A 'file' which the KCfgCreator will parse on startup."), 0 },
    { 0, 0, 0 }
};

int
main( int argc, char **argv )
{
    KAboutData *about = new KAboutData( "kcfgcreator", I18N_NOOP("KCfgCreator"),
                                        "0.3.1",
                                        I18N_NOOP("Helps to create Kcfg and Kcfgc files."),
                                        KAboutData::License_LGPL,
                                        "(C) 2003-2005 Zack Rusin" );
    about->addAuthor( "Zack Rusin",
                      I18N_NOOP("Author"), "zack@kde.org" );

    KCmdLineArgs::init( argc, argv, about );
    KCmdLineArgs::addCmdLineOptions( kconf_options );
    KApplication a;

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    Kernel k;
    Creator *creator = new Creator();

    // file to open
     for ( int i = 0; i < args->count(); i++ ) {
         creator->openURL( args->url( i ) );
     }
     args->clear(); // Free up some memory.

    a.setMainWidget( creator );
    creator->show();

    return a.exec();
}
