/**
 * kernel.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#include "kernel.h"

#include "downloader.h"
#include "uploader.h"
#include "kconfigparser.h"
#include "configmanager.h"
#include "token.h"

#include <kconfig.h>
#include <kstaticdeleter.h>

namespace KCfgCreator
{

Kernel*  Kernel::s_self=0;

KConfig* Kernel::s_config=0;
static KStaticDeleter<KConfig> s_configSD;

Kernel::Kernel( QObject* parent, const char* name )
    : QObject( parent, name )
{
    Q_ASSERT( !s_self );

    m_downloader = new Downloader( this );
    m_uploader   = new Uploader( this );
    m_manager    = new ConfigManager( this );

    connect( m_downloader, SIGNAL(done(HostData*)),
             m_manager, SLOT(slotParseData(HostData*)) );
    connect( m_manager, SIGNAL(newHostParsed(HostToken*)),
             SIGNAL(parsedHost(HostToken*)) );
    connect( m_manager, SIGNAL(hostReparsed(HostToken*)),
             SIGNAL(reparsedHost(HostToken*)) );

    s_self = this;
}

Kernel::~Kernel()
{
    s_self = 0;
}

void
Kernel::emitStatusMsg( const QString& msg )
{
    emit statusMsg( msg );
}

void
Kernel::emitLogMsg( const QString& component, const QString& msg )
{
    emit logMsg( component, msg );
}

KConfig*
Kernel::config()
{
    if ( !s_config )
        s_configSD.setObject( s_config, new KConfig( "kconfigeditorrc" ) );
    return s_config;
}

Downloader*
Kernel::downloader() const
{
    return m_downloader;
}

Uploader*
Kernel::uploader() const
{
    return m_uploader;
}

}

#include "kernel.moc"
