/**
 * kcfgentryeditor.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef KCFGENTRYEDITOR_H
#define KCFGENTRYEDITOR_H

#include "kcfgeditui.h"

namespace KCfgCreator {

    class EntryItem;

    class EntryEditor : public KCFGEditUI
    {
        Q_OBJECT
    public:
        EntryEditor( QWidget *parent );

    public slots:
        void updateEntry( EntryItem *item );

    protected slots:
        void slotNameChanged( const QString& );
        void slotKeyChanged( const QString& );
        void slotTypeChanged( const QString& );
        void slotHiddenToggled( bool );
        void slotLabelChanged( const QString& );
        void slotWhatsThisChanged();
        void slotDefaultValueChanged( const QString& );
        void slotDefaultCodeToggled( bool );
        void slotMinChanged( const QString& );
        void slotMinCodeToggled( bool );
        void slotMaxChanged( const QString& );
        void slotMaxCodeToggled( bool );
        void slotValueAdded( const QString& );
        void slotValueRemoved( const QString& );
        void slotAddChoiceClicked();
        void slotModifyChoiceClicked();
        void slotRemoveChoiceClicked();
        void slotParamNameChanged( const QString& );
        void slotParamTypeChanged( const QString& );
        void slotParamMaxChanged( int );
        void slotParamValueAdded( const QString& );
        void slotParamValueRemoved( const QString& );

    private:
        void initConnections();
    private:
        EntryItem *m_item;
    };

}

#endif
