/**
 * kernel.h
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */
#ifndef KONFIG_KERNEL_H
#define KONFIG_KERNEL_H

#include <qobject.h>
#include <qptrlist.h>

class KConfig;

namespace KCfgCreator
{

#define kernel Kernel::self()

    class ApplicationToken;
    class HostToken;
    class ParserInterface;
    class Downloader;
    class Uploader;
    class ConfigManager;

    class Kernel : public QObject
    {
        Q_OBJECT
    public:
        Kernel( QObject* parent=0, const char* name=0 );
        ~Kernel();

        static Kernel* self()  { return s_self; }
        static KConfig* config();

        Downloader* downloader() const;
        Uploader* uploader() const;

    public slots:
        void emitStatusMsg( const QString& msg );
        void emitLogMsg( const QString& component, const QString& msg );

    signals:
        void parsedHost( HostToken* );
        void reparsedHost( HostToken* );
        void statusMsg( const QString& );
        void logMsg( const QString& component, const QString& msg );
    private:

        Downloader*    m_downloader;
        Uploader*      m_uploader;
        ParserInterface* m_parser;
        ConfigManager*   m_manager;

    private:
        static KConfig* s_config;
        static Kernel*  s_self;
    };

}

#endif
