/**
 * items.h
 *
 * Copyright (C)  2003  Zack Rusin <zack@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef KCFGCREATOR_ITEMS_H
#define KCFGCREATOR_ITEMS_H

#include <klistview.h>
#include <kurl.h>

#include <qmap.h>
#include <qstringlist.h>

namespace KCfgCreator
{
    class EntryToken;
    class GroupToken;
    class ApplicationToken;
    class HostToken;
    class ConfItem : public KListViewItem
    {
    public:
        enum Type {
            None=0,
            Entry,
            Group,
            App,
            Host
        };
        ConfItem( KListView* parent, const QString& name );
        ConfItem( KListView* parent, ConfItem* after, const QString& label1,
                  const QString& label2 = QString::null, const QString& label3 = QString::null,
                  const QString& label4 = QString::null, const QString& label5 = QString::null,
                  const QString& label6 = QString::null, const QString& label7 = QString::null,
                  const QString& label8 = QString::null );
        ConfItem( ConfItem* parent, const QString& name );
        ConfItem( ConfItem* parent, const QString& name, const QString& value );

        virtual QString     name() const =0;
        virtual Type        type() const =0;
    };

    class AppItem : public ConfItem
    {
    public:
        AppItem( KListView* view, const QString& name );
        AppItem( KListView* view, ApplicationToken* app );
        ~AppItem();

        void setName( const QString& );
        QString name() const;
        Type type() const { return App; }

        QStringList groupList() const;
        GroupToken *group( const QString& ) const;
        ApplicationToken* app() const;
    private:
        void init( const QString& );
        ApplicationToken* m_token;
    };

    class GroupItem : public ConfItem
    {
    public:
        GroupItem( AppItem* parent, const QString& name );
        GroupItem( AppItem* parent, GroupToken* token );

        QString name() const;
        Type type() const { return Group; }

        EntryToken* entry( const QString& );
        QMap<QString, QString> entriesMap() const;
        GroupToken* group() const;
    private:
        GroupToken* m_token;
    };

    class EntryItem : public ConfItem
    {
    public:
        EntryItem( GroupItem* parent, const QString& name );
        EntryItem( GroupItem* parent, EntryToken* token );

        EntryToken* token() const { return m_token; }
        QString name() const;
        Type type() const { return Entry; }

        QString value() const;
        void update();

        void switchTokens( EntryToken* );

    private:
        EntryToken* m_token;
    };

}

#endif
