/**
 * applicationtoken.cpp
 *
 * Copyright (C)  2004  Zack Rusin <zack@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 */

#include "applicationtoken.h"
#include "grouptoken.h"
#include "undomanager.h"
#include "memento.h"

using namespace KCfgCreator;

ApplicationToken::ApplicationToken( const KURL& url, const QString& name )
    : Token( name ), m_url( url )
{
    m_groupList.setAutoDelete( true );
}

ApplicationToken::~ApplicationToken()
{
}

ApplicationToken::GroupList
ApplicationToken::groupList() const
{
    return m_groupList;
}

GroupToken*
ApplicationToken::group( const QString& name ) const
{
    QPtrListIterator<GroupToken> itr( m_groupList );

    while ( itr.current() ) {
        if ( itr.current()->name() == name )
            return itr.current();
        ++itr;
    }
    return 0;
}

GroupToken*
ApplicationToken::createGroup( const QString& name, bool readOnly )
{
    GroupToken* token = new GroupToken( this, name, readOnly );
    m_groupList.append( token );

    //TODO: add memento
    incrementModificationCount();

    return token;
}

void
ApplicationToken::removeGroup( const QString& name )
{
    QPtrListIterator<GroupToken> itr( m_groupList );

    while ( itr.current() ) {
        if ( itr.current()->name() == name ) {
            m_groupList.remove(  itr.current() );
            return;
        }
        ++itr;
    }

    //TODO: add memento
    incrementModificationCount();
}

void
ApplicationToken::removeGroup( GroupToken *group )
{
    m_groupList.remove( group );

    //TODO: add memento
    incrementModificationCount();
}

KURL
ApplicationToken::url() const
{
    return m_url;
}

void
ApplicationToken::setURL( const KURL& url )
{
    m_url = url;

    //TODO: add memento
    incrementModificationCount();
}

QStringList
ApplicationToken::includeFiles() const
{
    return m_includeList;
}

void
ApplicationToken::addIncludeFile( const QString& file )
{
    m_includeList.append( file );
}

void
ApplicationToken::setIncludeList( const QStringList& l )
{
    m_includeList = l;

    //TODO: add memento
    incrementModificationCount();
}

QStringList
ApplicationToken::parameters() const
{
    return m_parameters;
}

void
ApplicationToken::addParameter( const QString& par )
{
    m_parameters.append( par );

    //TODO: add memento
    incrementModificationCount();
}
