/***************************************************************************
                          mybroswerinfo.h  -  description
                             -------------------
    begin                : Thu Mar 29 2001
    copyright            : (C) 2001 by Jochen Schmitt
    email                : Jochen@herr-schmitt.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYBROSWERINFO_H
#define MYBROSWERINFO_H

#include <qobject.h>
#include <qstring.h>
#include <qlistbox.h>
#include <stdlib.h>
#include <strings.h>

#include <unistd.h>
#include <sys/stat.h>

typedef struct _browser {
  char *tag;
	char *desc;
	char *fname;
} BROWSER_INFO;

/**
  *@author Jochen Schmitt

  This class is responsible to organize the selection
  of the used browser.

  */

class MyBrowserInfo : public QObject{
Q_OBJECT
private:
  QString mbrowser;
  /**  */
  QString moldbrowser;
  void getBrowser(QListBox *l, char *pfad);

public:
	MyBrowserInfo();
	~MyBrowserInfo();
	/** Fill the listbox, given as the parameter of the method,
	    with the available browsers.
	
	    @param l Listbox to be filled.
	*/
	void fillListbox(QListBox *l);
	
	/** Execute the URL short cut, which is given as a QString-Parameter
	
		  @param s Name of the URL short cut.
		
		  @return True, if the URL short cut could be resolve.
	*/
	bool Exec(const QString &s);
  /** Save the selected browser in the profile of the program. */
  void saveProfile();
  /** This method will be called, if a entry of
	    the browser selection list will be selected.
    */
  void setSelected(const QString&);
  /** This method indicates if the browser selection was changed. */
  bool changed();
};

extern MyBrowserInfo *gmbinfo;

#endif
