  /*

  knetfilter v 2.0.1

  Copyright (C) 2000 Luigi Genoni
  		     venom@DarkStar.sns.it
  */
  

#include <qlayout.h>
#include <qmultilinedit.h>
#include <qkeycode.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qstring.h>
#include <qstrlist.h>
#include <strings.h>

#include "knat.h"


// creating widgets
void knetfilter::setupknetfilterWidget() {

  QWidget *mainWidget = new QWidget(this);

  QBoxLayout *top = new QBoxLayout(mainWidget, QBoxLayout::LeftToRight, 12);
  QGridLayout *grid = new QGridLayout(12,12);
  top->addLayout(grid,12);

  QLabel *labelSourcePort = new QLabel(mainWidget);
  labelSourcePort->setText("Source Port:");

  addSourcePort = new QLineEdit(mainWidget);
  addSourcePort->setFixedHeight(addSourcePort->sizeHint().height());
  addSourcePort->setText("");

  QLabel *labelDestinationPort = new QLabel(mainWidget);
  labelDestinationPort->setText("Destination Port:");

  addDestinationPort = new QLineEdit(mainWidget);
  addDestinationPort->setFixedHeight(addDestinationPort->sizeHint().height());
  addDestinationPort->setText("");

  QLabel *labelIcmpType = new QLabel(mainWidget);
  labelIcmpType->setText("ICMP Type:");

  addIcmpType = new QLineEdit(mainWidget);
  addIcmpType->setFixedHeight(addIcmpType->sizeHint().height());
  addIcmpType->setText("");

  QLabel *labelRuleNumber = new QLabel(mainWidget);
  labelRuleNumber->setText("Rule Position:");

  addRuleNumber = new QLineEdit(mainWidget);
  addRuleNumber->setFixedHeight(addRuleNumber->sizeHint().height());
  addRuleNumber->setText("");

  grid->addMultiCellWidget(labelSourcePort,0,0,0,1);
  grid->addMultiCellWidget(addSourcePort,0,0,2,3);

  grid->addMultiCellWidget(labelDestinationPort,1,1,0,1);
  grid->addMultiCellWidget(addDestinationPort,1,1,2,3);

  grid->addMultiCellWidget(labelIcmpType,2,2,0,1);
  grid->addMultiCellWidget(addIcmpType,2,2,2,3);

  grid->addMultiCellWidget(labelRuleNumber,3,3,0,1);
  grid->addMultiCellWidget(addRuleNumber,3,3,2,3);

  QLabel *labelInterface = new QLabel(mainWidget);
  labelInterface->setText("Interface:");
  grid->addMultiCellWidget(labelInterface,4,4,0,1);

  interface = new QComboBox( FALSE, mainWidget, "interface");
  interface->insertItem("Please Select");
  interface->insertItem("eth");
  interface->insertItem("tr");
  interface->insertItem("lec");
  interface->insertItem("atm");
  interface->insertItem("bond");
  interface->insertItem("lo");
  interface->insertItem("slip");
  interface->insertItem("plip");
  interface->insertItem("ppp");
  interface->insertItem("ippp");
  interface->insertItem("tap");
  interface->insertItem("tun");
  interface->setFixedHeight(interface->sizeHint().height());
  connect(interface,SIGNAL(activated(int)), SLOT(interfaceActivated(int)));
  grid->addMultiCellWidget(interface,4,4,2,3);

  QLabel *labelInterfacenr = new QLabel(mainWidget);
  labelInterfacenr->setText("Interface nr:");
  grid->addMultiCellWidget(labelInterfacenr,5,5,0,1);

  interfacenr = new QComboBox( FALSE, mainWidget, "interface nr");
  interfacenr->insertItem("0");
  interfacenr->insertItem("1");
  interfacenr->insertItem("2");
  interfacenr->insertItem("3");
  interfacenr->insertItem("4");
  interfacenr->insertItem("5");
  interfacenr->setFixedHeight(interfacenr->sizeHint().height());
  connect(interfacenr,SIGNAL(activated(int)), SLOT(interfacenrActivated(int)));
  grid->addMultiCellWidget(interfacenr,5,5,2,3);

  QLabel *labelChain = new QLabel(mainWidget);
  labelChain->setText("Chain:");

  chain = new QComboBox( FALSE, mainWidget, "Chain");
  chain->insertItem("INPUT");
  chain->insertItem("OUTPUT");
  chain->insertItem("FORWARD");
  chain->setFixedHeight(chain->sizeHint().height());
  connect(chain,SIGNAL(activated(int)), SLOT(chainActivated(int)));

  grid->addMultiCellWidget(labelChain,0,0,5,6);
  grid->addMultiCellWidget(chain,0,0,6,7);


  QLabel *labelPolicy = new QLabel(mainWidget);
  labelPolicy->setText("Policy:");

  policy = new QComboBox( FALSE, mainWidget, "Policy");
  policy->insertItem("DROP");
  policy->insertItem("REJECT");
  policy->insertItem("ACCEPT");
  policy->insertItem("RETURN");
  policy->insertItem("QUEUE");
  policy->insertItem("MIRROR");
  policy->setFixedHeight(policy->sizeHint().height());
  connect(policy,SIGNAL(activated(int)), SLOT(policyActivated(int)));

  grid->addMultiCellWidget(labelPolicy,1,1,5,6);
  grid->addMultiCellWidget(policy,1,1,6,7);

  QLabel *labelFlag = new QLabel(mainWidget);
  labelFlag->setText("tcp flags:");

  flags = new QComboBox( FALSE, mainWidget, "Flags");
  flags->insertItem(" ");
  flags->insertItem("SYN");
  flags->setFixedHeight(flags->sizeHint().height());
  connect(flags,SIGNAL(activated(int)), SLOT(flagsActivated(int)));

  grid->addMultiCellWidget(labelFlag,0,0,8,9);
  grid->addMultiCellWidget(flags,1,1,8,9);

  QLabel *labelState = new QLabel(mainWidget);
  labelState->setText("packet's state:");

  state = new QComboBox( FALSE, mainWidget, "Packet's State:");
  state->insertItem("don't track connection");
  state->insertItem("INVALID (unknown conn.)");
  state->insertItem("ESTABLISHED (existing conn.)");
  state->insertItem("NEW (starting new conn.)");
  state->insertItem("RELATED (conn. related to another)");
  state->setFixedHeight(state->sizeHint().height());
  connect(state,SIGNAL(activated(int)), SLOT(stateActivated(int)));
  
  grid->addMultiCellWidget(labelState,7,7,0,1);
  grid->addMultiCellWidget(state,7,7,2,4);  

  QLabel *labelextraNet = new QLabel(mainWidget);
  labelextraNet->setText("Source Address/NetMask:");

  extraNet  =  new QLineEdit(mainWidget);
  extraNetMask  =  new QLineEdit(mainWidget);

  extraNet->setFixedHeight(extraNet->sizeHint().height());
  extraNetMask->setFixedHeight(extraNetMask->sizeHint().height());

  grid->addMultiCellWidget(labelextraNet,9,9,0,2);
  grid->addMultiCellWidget(extraNet,9,9,3,4);
  grid->addMultiCellWidget(extraNetMask,9,9,5,6);

  QLabel *labelIp = 		new QLabel(mainWidget);
  labelIp->setText("Destination Address/NetMask:");

  ipAddr = 	new QLineEdit(mainWidget);
  netmaskAddr =	new QLineEdit(mainWidget);

  ipAddr->setFixedHeight(ipAddr->sizeHint().height());
  netmaskAddr->setFixedHeight(netmaskAddr->sizeHint().height());

  grid->addMultiCellWidget(labelIp,10,10,0,2);
  grid->addMultiCellWidget(ipAddr,10,10,3,4);
  grid->addMultiCellWidget(netmaskAddr,10,10,5,6);
    
  messageLog = new QListBox(mainWidget);
  
  grid->addMultiCellWidget(messageLog,2,8,5,9);

  setView(mainWidget);

};


