/*
    KMLOVoice

    A utility to process voice messages received with the ELSA
    MicroLink(tm) Office modem.

    Copyright (C) 2000 Oliver Gantz <Oliver.Gantz@epost.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ------
    ELSA and MicroLink are trademarks of ELSA AG, Aachen.
*/

#ifndef PLAYBACK_H
#define PLAYBACK_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <stdio.h>

#include <qwidget.h>
#include <qpopupmenu.h>
#include <qpixmap.h>
#include <qslider.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qtimer.h>
#include <qsocketnotifier.h>
#include <qlabel.h>

#include <qframe.h>

#include <ktmainwindow.h>
#include <kconfig.h>
#include <kaccel.h>


#define ID_PRE_FILE_PLAY            10010
#define ID_PRE_FILE_STOP            10020
#define ID_PRE_FILE_EXPORT          10030
#define ID_PRE_FILE_MAIL            10040
#define ID_PRE_FILE_CLOSE           10050

#define ID_PRE_SETTINGS_TOOLBAR     11010
#define ID_PRE_SETTINGS_STATUSBAR   11020
#define ID_PRE_SETTINGS_SAVEOPTIONS 11030

#define ID_PRE_STATUS_NAME           1001
#define ID_PRE_STATUS_SPEED          1002
#define ID_PRE_STATUS_BITS           1003



class PlayBackWidget : public QWidget
{
	Q_OBJECT
public:
	PlayBackWidget(QWidget *parent = 0, const char *name = 0);
	virtual ~PlayBackWidget();

	void setFileSize(int size, int secs);
	void setFilePos(int pos_);
	void setLevel(int level);

signals:
	void position(int);
	
protected:
	bool initMixer();

protected slots:
	void volumePressed();
	void volumeReleased();
	void monitorVolume();
	void setVolume(int val);

	void posPressed();
	void posReleased();
	
private:
	QFrame *meter_frames[12];
	
	QSlider *pos, *volume;
	QLabel *midlabel, *maxlabel;

	QTimer *timer;
	int mixer_fd;
	bool pcm_stereo;
	bool tracked;
};


class PlayBack : public KMainWindow
{
	Q_OBJECT
public:
	PlayBack(QWidget *parent = 0, const char *name = 0);
	virtual ~PlayBack();

	void playMessage(const QString& name, uchar type);

	void enableCommand(int id_, bool enable);

protected:
	void resetFile();
	
	void readOptions();
	void saveOptions();

	void initMenuBar();
	void initToolBar();
	void initStatusBar();
	void initKeyAccel();

public slots:
	void commandCallback(int id_);

	void slotFilePlay();
	void slotFileStop();
	void slotFileExport();
	void slotFileMail();

	void slotSettingsShowToolbar();
	void slotSettingsShowStatusbar();
	
	void slotStatusName(const QString& text);
	void slotStatusSpeed(int speed);
	void slotStatusBits(int bits);

	void slotPosition(int pos);

	void slotPlayData(int);

	virtual void hide();

private:
	KConfig *config;

	KAccel *keyAccel;

	PlayBackWidget *view;

	QPopupMenu *fileMenu;
	QPopupMenu *settingsMenu;

	QString m_name;
	uchar m_type;
	int m_speed;
	int file_size;
	int file_pos;
	bool playing;
	int dsp_fd;
	int data_size;
	uchar *data_buff;
	QSocketNotifier *sn;
	FILE *tmp_f;
};


#endif // PLAYBACK_H
