/***************************************************************************
                          ksystrayview.cpp  -  description
                             -------------------
    begin                : Tue Oct 10 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include <qdom.h>
#include <kdebug.h>
#include <klocale.h>
//#include "ktmanager.h"
//#include "ktransfer.h"
#include <qdragobject.h>
#include "kmago.h"
#include "ksystrayview.h"

KSysTrayView::KSysTrayView(QWidget *parent, const char *name ) : 
  KSystemTray(parent,name) {
  setPixmap(SmallIcon("kmago"));
  setAcceptDrops(true);

  KPopupMenu *menu = contextMenu();
#ifndef KACTION_ERR
  mainView()->fileSelectMngr->plug(menu);
#else
  fileSelectMngr = new KListAction(i18n("Select Manager"),
				    0, mainView(), SLOT(slotFileSelectMngr(int)),
				    this);
  fileSelectMngr->plug(menu);
#endif
  mainView()->separator->plug(menu);
  mainView()->managerAdd->plug(menu);
  mainView()->managerPaste->plug(menu);
#ifndef KACTION_ERR
  mainView()->managerAddRecent->plug(menu);
#else
  managerAddRecent = 
    new KRecentFilesAction(i18n("Add Recent Transfer"), 0, 
			   mainView(), SLOT(slotManagerAddRecent(const KURL&)),
			   this);
  managerAddRecent->plug(menu);
#endif
  mainView()->separator->plug(menu);
  mainView()->managerPauseAll->plug(menu);
  mainView()->managerAutoDownload->plug(menu);
  mainView()->separator->plug(menu);
  mainView()->managerConf->plug(menu);
}

KSysTrayView::~KSysTrayView(){
}

KMagoApp * KSysTrayView::mainView() const { 
  return dynamic_cast<KMagoApp*>(parent());
}

void KSysTrayView::dragEnterEvent(QDragEnterEvent *event) {
  kdDebug() << name() << ": drag enter" << endl;
  event->accept(QTextDrag::canDecode(event) || QUriDrag::canDecode(event));
}

/* 
void KSysTrayView::dragMoveEvent(QDragMoveEvent *event) {
  event->acceptAction(event->source() != this);
}

void KSysTrayView::dragLeaveEvent(QDragLeaveEvent *) {
kdDebug() << name() << ": drag leave" << endl;
}
*/
void KSysTrayView::dropEvent(QDropEvent *event) {
  kdDebug() << "SYSTRAY: DROP EVENT " << endl;
  //event->acceptAction(true);
  QStringList uris;
  QString text;
  if (QUriDrag::decodeToUnicodeUris(event, uris)) {
    kdDebug() << "SYSTRAY: URIS=" << uris.join(",") << endl;
    for (QStringList::Iterator i = uris.begin(); i != uris.end(); ++i)
      mainView()->addTransfer(*i);
  } else if (QTextDrag::decode(event, text)) {
    kdDebug() << "SYSTRAY: TEXT=" << text << endl;
    text.stripWhiteSpace();
    mainView()->addTransfer(text);
  }
}

#include "ksystrayview.moc"
