/***************************************************************************
                          kobject.h  -  description
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.5 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KOBJECT_H
#define KOBJECT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdom.h>
#include "km.h"

#ifdef DMALLOC
#include <dmalloc.h>
#endif


using namespace KM;

class KObjectImpl;
class KMManagerImpl;
class KContainer;
class KTManager;
class KMManager;
class KTransfer;
class KTransferWget;
#ifdef ENABLE_KIO
class KTransferKio;
#endif
//class KObject;

/** 
 * @short Bridge class for @ref KObjectImpl 
 * @author Sergio Moretti
 * @version $Id$
 */
class KObject {

  friend class KObjectImpl;
  friend class KMManagerImpl;
  friend class KTransfer;
  friend class KTransferWget;
#ifdef ENABLE_KIO
  friend class KTransferKio;
#endif
  friend class KContainer;
  friend class KTManager;
  friend class KMManager;

public:
  typedef QValueList<KObject> List;

  /** constructor */
  KObject() : _impl(0) {}
  /** object is null */
  bool isNull() const { return impl() == 0; }
  void setNull() { _impl = 0; }
  /** identity of object */
  int id() const;
  /** string identifier of object */
  QString name() const;
  /** parent container */
  KContainer container() const;
  int type() const;
  QDomElement dom() const;
  bool isModified(ModType type) const;
  void setModified(ModType type, PropMode prop, bool mod = true);
  bool isGlobal() const;
  void setGlobal(bool g);
  void update();
  /** destroy implementation instance */
  void deleteInstance();
  /** run this procedure periodically */
  void runPeriodically();
  /** connect object's signal to slots */
  bool connect(const char *signal, const QObject *receiver, 
	       const char *member) const;
  /** conversions */
  QObject * toQObject() const;
  KContainer toContainer() const;
  KTransfer toTransfer() const;
  KTManager toTManager() const;
  KMManager toMManager() const;
  KTransferWget toTransferWget() const;
#ifdef ENABLE_KIO
  KTransferKio toTransferKio() const;
#endif

  bool operator==(const KObject &o) const { return impl() == o.impl(); }
  bool operator!=(const KObject &o) const { return impl() != o.impl(); }
  static KObject null() { return KObject(); }

  static QString typeStr(int type);
  static void initFactory();

protected:
  KObject(KObjectImpl *impl) : _impl(impl) {}
  KObjectImpl * impl() const { return _impl; }

private:
  KObjectImpl *_impl;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
