/***************************************************************************
                          kmmanager.cpp  -  description
                             -------------------
    begin                : Fri Oct 20 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.2 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmmanagerimpl.h"
#include "ktmanager.h"
#include "kmmanager.h"


KMManager KMManager::managerLoad(const QString &fileName, bool createMode,
			KNotifyChange *cb) {
  return KMManager(KMManagerImpl::managerLoad(fileName, createMode, cb));
}

QString KMManager::fileName() const {
  return impl()->fileName();
}

bool KMManager::save(const QString &filename) {
  return impl()->save(filename);
}

KTManager KMManager::itemNew(const QString &title) {
  return KTManager(impl()->itemNew(title));
}

int KMManager::bandwidth() const {
  return impl()->bandwidth();
}

int KMManager::mediumBandwidth() const {
  return impl()->mediumBandwidth();
}

bool KMManager::needSaving() const {
  return impl()->needSaving();
}

QString KMManager::docId() { 
  return KMManagerImpl::DOCID; 
}

QString KMManager::docType() {
  return KMManagerImpl::DOCTYPE;
}

QString KMManager::mimeType(int i) {
  return KMManagerImpl::MIMETYPE[i];
}

KMManager::KMManager(KMManagerImpl *impl) : KContainer(impl) {
}

KMManagerImpl * KMManager::impl() const {
  return dynamic_cast<KMManagerImpl*>(KContainer::impl());
}
