/***************************************************************************
                          kmago.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.14 $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMAGO_H
#define KMAGO_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for KDE
#include <kapp.h>
#include <kmainwindow.h>
#include <qintdict.h>
//#include <kaccel.h>
#include <kaction.h>
#include <qstringlist.h>
#include "ktransfer.h"
#include "ktmanager.h"

#ifdef DMALLOC
#include <dmalloc.h>
#endif

// forward declaration of the KMago classes
class KMagoDoc;
class KMagoView;
class TransferView;
class KSysTrayView;

/**
  * The base class for KMago application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KMagoView creates your center view, which is connected
  * to the window's Doc object.
  * KMagoApp reimplements the methods that KTMainWindow provides for main window handling and supports
  * full session management as well as keyboard accelerator configuration by using KAccel.
  * @see KTMainWindow
  * @see KApplication
  * @see KConfig
  * @see KAccel
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 0.4 code generation
  */
class KMagoApp : public KMainWindow {

  Q_OBJECT

  friend class KSysTrayView;

  static const char IDS_STATUS_DEFAULT[];

public:
  /** construtor of KMagoApp, calls all init functions to create the application.
   * @see initMenuBar initToolBar
   */
  KMagoApp();
  ~KMagoApp();

  /** opens a new document */
  bool newDocument();
  /** opens a file specified by commandline option*/
  bool openDocument(const QString & fileToOpen);
  /** open last used document file */
  bool openLastUsedDocument();
  /** save document into another filename */
  bool saveAsDocument(const QString &newFile);
  /** close current document */
  void closeDocument();
  /** returns a pointer to the current document connected to the KTMainWindow instance and is used by
   * the View class to access the document object's methods
   */	
  KMagoDoc *getDocument() const { return doc; }

  /** return the current transfer */
  KTransfer currentTransfer() const { return _currentTransfer; }
  /** set the current transfer */
  void setCurrentTransfer(KTransfer tr);
  /** get the current manager */
  KTManager currentManager() const { return _currentManager; }
  /** set the current manager */
  void setCurrentManager(KTManager m);

  /** add a transfer */
  void addTransfer(const KURL &url);
  /** update the view */
  void resetView();

  QPopupMenu * transferMenu() const { return _transferMenu; }
  QPopupMenu * managerMenu() const { return _managerMenu; }

  QSize sizeHint() const;
  //virtual void resizeEvent ( QResizeEvent *event );

  // configuration
  
  /** get open dialog flags */
  int getOpenFlags() const { return _cfg_openFlags; }
  /** set open dialog flags */
  void setOpenFlags(int f) { _cfg_openFlags = f; }
  bool getExpertMode() const { return _cfg_expertMode; }
  void setExpertMode(bool m=true) { _cfg_expertMode = m; }
  int getUpdateTime() const { return _cfg_updateTime; }
  void setUpdateTime(int u);
  int getStartMode() const { return _cfg_startMode; }
  void setStartMode(int m) { _cfg_startMode = m; }
  bool getLoadLastDoc() const { return _cfg_loadLastDoc; }
  void setLoadLastDoc(bool l) { _cfg_loadLastDoc = l; }

protected:  
  /** initActions creates the actions for menus and toolbars */
  void initActions();
  /** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
   * @see KApplication#getHelpMenu
   */
  void initMenuBar();
  /** this creates the toolbars. */
  void initToolBar();
  /** sets up the statusbar for the main window by initialzing a statuslabel. */
  void initStatusBar();
  /** initializes the document object of the main window that is connected to the view in initView().
   * @see initView();
   */
  void initDocument();
  /** creates the centerwidget of the KTMainWindow instance and sets it as the view */
  void initView();
  /** create the system tray widget */
  void initSysTray();
  /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
   * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
   * be saved if Modified; on cancel the closeEvent is rejected.
   * @see KMainWindow#queryClose
   * @see KMainWindow#closeEvent
   */
  virtual bool queryClose();
  /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
   * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
   * properties.
   * @see KMainWindow#queryExit
   * @see KMainWindow#closeEvent
   */
  virtual bool queryExit();

  /** read state from config object */
  void readConfig(KConfig *config);
  /** save state to config object */
  void saveConfig(KConfig *config);
  /** load initial state, called by init */
  void loadState();
  /** save final state, called by queryExit */
  void saveState();

  /** saves the window properties for each open window during session end to the session config file, including saving the currently
   * opened file by a temporary filename provided by KApplication.
   * @see KMainWindow#saveProperties
   */
  virtual void saveProperties(KConfig *config);
  /** reads the session config file and restores the application's state including the last opened files and documents by reading the
   * temporary files saved by saveProperties()
   * @see KMainWindow#readProperties
   */
  virtual void readProperties(KConfig *config);
  
  /** manage saved state */
  bool stateChange(int p, bool val);

  /** return the number of transfers */
  int transferCount() const { return _transferCount; }
  /** close all windows related to transfer */
  void closeTransferWindows(KTransfer t);

public slots:
  // slots called from document tree

  /** called from transfermanager signalTransferAdd */
  void slotDocTransferAdd(KTransfer t);
  /** called from transfermanager signalTranferRemove */
  void slotDocTransferRemove(KTransfer t);
  /** update the view when the current transfer change */
  //void slotTransferCurrentChange(KTransfer *t);
  /** update the view when the current transfer state change */
  void slotDocTransferStateChange(KTransfer t);
  /** update the view when the current transfer config change */
  void slotDocTransferConfChange(KTransfer t);
  /** update the view when the current transfer read data */
  void slotDocTransferReadData(KTransfer t);
  /** update view when a manager is added */
  void slotDocTManagerAdd(KTManager m);
  /** update view when a manager is removed */
  void slotDocTManagerRemove(KTManager m);
  /** update visualization of manager properties */
  void slotDocTManagerStateChange(KTManager m);
  /** update visualization when doc is changed */
  void slotDocMManagerChange();
  
  //protected slots:
  /** open a new application window by creating a new instance of KMagoApp */
  void slotFileNewWindow();
  /** clears the document in the actual view to reuse it as the new document */
  void slotFileNew();
  /** open a file and load it into the document*/
  void slotFileOpen();
  /** opens a file from the recent files menu */
  void slotFileOpenRecent(const KURL &url);
  /** save a document by a new filename*/
  void slotFileSaveAs();
  /** asks for saving if the file is modified, then closes the actual file and window*/
  void slotFileClose();
  /** save a document */
  void slotFileQuit();
  /** select current manager */
  void slotFileSelectMngr(int i);
  /** add a manager */
  void slotFileAddMngr();
  
  /** put the marked text/object into the clipboard and remove
   *	it from the document
   */
  void slotEditCut();
  /** put the marked text/object into the clipboard
   */
  void slotEditCopy();
  /** paste the clipboard into the document
   */
  void slotEditPaste();
  
  /** add a new transfer to the transfers list*/
  void slotManagerAdd();
  /** add a new transfer from pasting*/
  void slotManagerPaste();
  /** add a transfer from the recent trasnfers list*/
  void slotManagerAddRecent(const KURL& u);
  /** enable/disable auto-downloading mode */
  void slotManagerAutoDownload();
  /** open the document configure dialog */
  void slotManagerConfigure();
  /** stop all transfers */
  void slotManagerPauseAll();
  /** remove a manager */
  void slotManagerRemoveMngr();
  
  /** start/resume transfer*/
  void slotTransferResume();
  /** pause transfer*/
  void slotTransferPause();
  /** remove transfer*/
  void slotTransferRemove();
  /** open dialog to view the transfer cmd output */
  void slotTransferLog();
  /** open the current transfer configure dialog */
  void slotTransferConfigure();
  /** enable/disable auto resuming */
  void slotTransferAutoResume();
  /** enable/disable auto check resume */
  void slotTransferAutoCheck();
  /** check for transfer resume capability */
  void slotTransferCheck();
  /** open the transfer status dialog */
  void slotTransferStatus();
  
  /** toggles the main toolbar*/
  void slotViewToolBarMain();
  /** toggles the transfers toolbar*/
  void slotViewToolBarTrn();
  /** toggles the statusbar*/
  void slotViewStatusBar();
  /** refresh the views */
  void slotViewRefresh();
  /** open the application preferences dialog */
  void slotViewPreferences();
  /** show/hide managers list */
  void slotViewManagers();
  /** set splitter orientation */
  void slotViewSplitOrient();
  /** show/hide system tray icon */
  void slotViewSysTray();
  
  /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
   * @param text the text that is displayed in the statusbar
   */
  void slotStatusMsg(const QString &text);
  /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
   * statusbar messages that give information about actions for toolbar icons and menuentries.
   * @param text the text that is displayed in the statusbar
   */
  void slotStatusHelpMsg(const QString &text);
  
  /** called when clipboard data change */
  void slotClipboardChange();

protected slots:
  void slotWndStatusClosed(int id);
  void slotWndLogClosed(int id);

private:
  /** view is the main widget which represents your working area. The View
   * class should handle all events of the view widget.  It is kept empty so
   * you can create your view according to your application's needs by
   * changing the view class.
   */
  KMagoView *view;
  /** system tray widget */
  KSysTrayView *sysTray;
  /** doc represents your actual document and is created only once. It keeps
   * information such as filename and does the serialization of your files.
   */
  KMagoDoc *doc;
  /** update on a regular base manager sync */
  QTimer* _timer;
  /** flag to recognize temporary documents */
  bool _tmpDoc;
  /** save buttons state to optimize visualization */
  int _savedState;
  /** last open document file */
  QString _lastUsedDocument;
  /** dictionary id/window of open log windows */
  QIntDict<QWidget> _logWnds;
  /** dictionary id/window of open status windows */
  QIntDict<QWidget> _statusWnds;
  /** current transfer */
  KTransfer _currentTransfer;
  /** current manager */
  KTManager _currentManager;
  /** number of transfers */
  int _transferCount;
  
  // configuration
  
  /** flags to control open dialog */
  int _cfg_openFlags;
  /** expert mode: don't prompt for delete operation*/
  bool _cfg_expertMode;	
  /** update time in seconds*/
  int _cfg_updateTime;
  /** what to do with ther last added transfer */
  int _cfg_startMode;
  /** load last document at startup */
  bool _cfg_loadLastDoc;
  
  // actions
  KAction
    *fileNewWindow,
    *fileNew,
    *fileOpen,
    *fileClose,
    *fileSaveAs,
    *fileQuit,
    *fileAddMngr,
    *editCopy,
    *editCut,
    *editPaste,
    *managerAdd,
    *managerConf,
    *managerPaste,
    *managerPauseAll,
    *managerRemoveMngr,
    *transferCheck,
    *transferConf,
    *transferPause,
    *transferRemove,
    *transferResume,
    *transferStatus,
    *transferLog,
    *viewRefresh,
    *viewPrefs,
    *separator;
  KRecentFilesAction
    *fileOpenRecent,
    *managerAddRecent;
  KToggleAction
    *managerAutoDownload,
    *transferAutoCheck,
    *transferAutoResume,
    *viewStatusBar,
    *viewToolBarMain,
    *viewToolBarTrn,
    *viewManagers,
    *viewSplitOrient,
    *viewSysTray;
  KListAction 
    *fileSelectMngr;

  QPopupMenu
    *_transferMenu,
    *_managerMenu;
};

#endif // KMAGO_H

/* Local Variables: */
/* mode: c++ */
/* End: */
