/***************************************************************************
                          rpm.cpp  -  description
                             -------------------
    begin                : Fri Dec 17 1999
    copyright            : (C) 1999 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rpm.h"

#include "../config.h"
#ifdef HAVE_LIBRPM

#include <fcntl.h>
#include <rpm/rpmlib.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <iostream.h>

RPM::~RPM(){
}

RPM::RPM(const QString n, unsigned int s){
	sg = 0;
	ts = 0;
	setName(n);
	setSafetyLevel(s);
	setType(TYPE_RPM);
	if (name().left(4) != "dev-")
		loadFiles();
}

void RPM::loadFiles(){
  unloadFiles();
	char **fileList;	
	int count, tp;

	rpmReadConfigFiles(NULL,NULL);
	rpmdb db;
	if (rpmdbOpen("", &db, O_RDONLY, 0644)) {
		KMessageBox::information(0,"ERROR");
	}

	rpmdbMatchIterator mi;
	mi=rpmdbInitIterator(db, RPMDBI_LABEL, QFile::encodeName(name()), 0);
	Header h;
	h = rpmdbNextIterator(mi);

	char *p;
//  headerGetEntry(h, RPMTAG_NAME, &tp, (void **) p, &count);
	rpmBuildFileList(h, (const char ***) &fileList, &count);
	if(fileList != 0){
		sg = 0;
		ts = 0;
		for(int i=0; i < count; i++){
			QString s(fileList[i]);
			QFileInfo fi(s);
			if (fi.isFile()){
				addFileFast(s);
				ts += fi.size();
				if (isSafe(s))
					sg += fi.size();
			}
		}
		free(fileList);
	}
	rpmdbClose(db);
}

ABProcess *  RPM::unInstall(){
	ABProcess * r = new ABProcess();
	*r << "rpm";
	*r << "-e";
	*r << name();
	return r;
}

QString RPM::info(infotag i){
	QString b; //return value
	QString n(name());

  rpmReadConfigFiles("","");
	rpmdb db;
	if (rpmdbOpen("", &db, O_RDONLY, 0644)) {
		KMessageBox::information(0,i18n("Cannot open rpm database"));
	}
	Header h;
	int tp, count;
	char * p;
	rpmdbMatchIterator mi;
	mi=rpmdbInitIterator(db, RPMDBI_LABEL, QFile::encodeName(name()), 0);
	h = rpmdbNextIterator(mi);
	switch (i){
		case INFO_NAME:
			headerGetEntry(h, RPMTAG_NAME, &tp, (void **) &p, &count);
		  b = QString(p);
			break;
		case INFO_DESCRIPTION:
			headerGetEntry(h, RPMTAG_DESCRIPTION, &tp, (void **) &p, &count);
		  b = QString(p);
			break;}
/*
		case INFO_REQUIRENAME:
			headerGetEntry(h, RPMTAG_REQUIREFLAGS, &tp, (void **) &p, &count);
		  b = QString(p);
			break;	}
*/
	rpmdbClose(db);
	return b;
}

unsigned int RPM::numDeps(){
/*
	int stat;
	rpmdb db;
	dbiIndexSet matches;
	unsigned int r = 0;
	QString n = info(INFO_NAME);

  rpmReadConfigFiles("","");
	if (rpmdbOpen("", &db, O_RDONLY, 0644)) {
		KMessageBox::information(0,i18n("Cannot open rpm database"));
	}

  stat = rpmdbFindByRequiredBy(db, const_cast<char*>(n.ascii()), &matches);
	if (stat == 0)
		r = matches.count;
	return r;
*/}

#else
RPM::~RPM(){}
RPM::RPM(const QString , unsigned int ){}
void RPM::loadFiles(){}
ABProcess *  RPM::unInstall(){return 0;}
QString RPM::info(infotag){return 0;}
unsigned int RPM::numDeps(){return 0;}
#endif
