/***************************************************************************
                          duptree.cpp  -  description
                             -------------------
    begin                : Sat Mar 24 2001
    copyright            : (C) 2001 by Arjan Buursink
    email                : buursink@wanadoo.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream.h>
#include <abfileinfo.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <klocale.h>
#include "duptree.h"
#include "groupviewwidget.h"

DUPTree::DUPTree(GroupViewWidget * gv) : GroupTree(gv){
	setType(TYPE_DUP);
	KIconLoader l;
	topItem() -> setText(0,"Duplicate Files");
	topItem() -> setPixmap(0,l.loadIcon("editcopy", KIcon::Small));	
}

DUPTree::~DUPTree(){
}

void DUPTree::update(QString dir){
	dup = new DUP();
	dup -> setName(i18n("Updated from") + " (" + dir + ")");
	updateProcess = new ABProcess();
	updateProgress = new ButtonLabelWidget(0,0,true);
	updateProgress -> setCaption(i18n("Analyzing files..."));
	connect(updateProgress -> PushButton1, SIGNAL(clicked()),SLOT(slotUpdateReady()));
	updateProgress -> show();
	if (dir != QString("")){
		connect(updateProcess, SIGNAL(receivedStdout(KProcess *,char *, int))
		,SLOT(slotUpdateGroups(KProcess *,char *,int )));
		connect(updateProcess, SIGNAL(processExited(KProcess *)),SLOT(slotUpdateReady()));
		updateProcess -> clearArguments();
		*updateProcess << "find";
		*updateProcess << dir;
		updateProcess -> exec();
	}
}

void DUPTree::slotUpdateGroups(KProcess *, char * b, int l){
	QString f;
	ABFileInfo fi;
  char * nb = new char[l+1];
  for (int i = 0; i <= l - 1; i++)
		nb[i] = b[i];
	nb[l] = '\0';
	std.append(nb);
	delete nb;
	uint i = 1;
	QString txt = "";
  while (i <= std.length()){
		if (std.mid(i,1) == "\n"){
	 		f = std.left(i);
	 		fi.setFile(f);
	 		txt = fi.dirPath();
			if (updateProgress -> TextLabel1 -> text() != txt)
				updateProgress -> TextLabel1 -> setText(txt);
			if (fi.isFile() & (fi.ownerId()==getuid() | getuid() == 0)){
				QString n,s;
				s = n.setNum(fi.crc());
				s += n.setNum(fi.size());
				list.append(s + fi.absFilePath());
			}
			std = std.right( std.length() - i - 1);
			i = 0;
		}
		i++;
  }
}

void DUPTree::itemClicked(QListViewItem * i, const QPoint &p, int c){
	if (topItem() -> childCount() == 0)
		slotUpdate();
	if (i  == topItem())
		topItem() -> setOpen(!topItem() -> isOpen());
	if (i -> parent() == topItem()){
		switch (c){
			case 0:
				emit setupFileList(group(name(i)));
				emit setProperties(group(name(i)));
				break;
		}
	}
	if (topItem() -> childCount() > 0)
		setupReady();
}

void DUPTree::updateReady(){
	delete updateProcess;
	delete updateProgress;
	QString crc1,crc2,crc3,file2;
	list.sort();
	for (unsigned int i = 0; i < list.count(); i++){
		crc1 = QString(list.at(i-1)).left(QString(list.at(i-1)).find('/') );
		crc2 = QString(list.at(i)).left(QString(list.at(i)).find('/') );
		file2 = QString(list.at(i)).right(QString(list.at(i)).length() - QString(list.at(i)).find('/'));
		crc3 = QString(list.at(i+1)).left(QString(list.at(i+1)).find('/'));
		if ((crc1 == crc2 ) || (crc2 == crc3)){
			dup -> addFile(file2);
			unsigned short * n = new unsigned short;
			*n = crc2.toUShort();
			dup -> addCRC(n);
		}
	}
	list.clear();
	addGroup(dup);
	setupItem(dup, item(topItem(), dup -> name()) );
	topItem() -> setOpen(true);
	setupReady();
}

void DUPTree::slotUpdate(){
  KConfig * config = KGlobal::config();
  config -> setGroup("DUP");
	update(config -> readEntry("Update Folder"));
	listView() -> setSelected(topItem(), true);
}

