/***************************************************************************
                          udgitem.cpp  -  description
                             -------------------
    begin                : Wed Dec 6 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "udgitem.h"
#include <stdlib.h>
#include <kiconloader.h>
#include <kstddirs.h>
#include <kmessagebox.h>
#include <udgdialog.h>
#include "groupviewwidget.h"
#include "info.h"
#include <iostream.h>

UDGItem::UDGItem(GroupManager * g, GroupViewWidget * gv) : GroupItem(g,gv){
  setType(TYPE_UDG);
	KIconLoader l;
	topItem() -> setText(0,"UDG");
	topItem() -> setPixmap(0,l.loadIcon("mime_empty", KIcon::Small));	
}

UDGItem::~UDGItem(){
}

void UDGItem::slotItemClicked(QListViewItem * i, const QPoint &p, int c){
	if (!groupManager() -> isInit(TYPE_UDG)){
		groupManager() -> init(TYPE_UDG);
		for (unsigned int i = 0; i < groupManager() -> count(TYPE_UDG); i++)
			udgToItem(groupManager() -> udg(i),new QListViewItem(topItem()) );
	}
	if (i != 0){
		if (i == topItem())
	    i -> setOpen(!i -> isOpen());
		if (i -> parent() == topItem()){
			switch (c){
				case 0:
					emit setupFileList(groupManager() -> udg(name(i)));
					emit setProperties(groupManager() -> udg(name(i)));
					break;
				case 7:
					if (!groupManager() -> udg(name(i)) -> schedule() -> isIllegalSchedule()){
						groupManager() -> udg(name(i)) -> setScheduleEnabled(!groupManager() -> udg(name(i)) -> scheduleEnabled());
						groupManager() -> udg(name(i)) -> save();
					}
					break;
			}
			udgToItem(groupManager() -> udg(name(i)), i);
		}
	}
}

void UDGItem::slotUpdateReady(){
	deleteChilderen();
	for (unsigned int i = 0; i < groupManager() -> count(TYPE_UDG); i++)
		udgToItem(groupManager() -> udg(i), new QListViewItem(topItem()));
	topItem() -> setOpen(true);
}

void UDGItem::udgToItem(UDG * u, QListViewItem * i){
	groupToItem(u,i);
	KIconLoader l;
	i -> setPixmap(0,l.loadIcon(u -> icon(), KIcon::Small));
	if (u -> scheduleEnabled()){
		if (u -> getAction() == DELETE_BACKUP){
			if (u -> missedScheduleEvent())
				i -> setPixmap(7,QPixmap(QString(getenv("KDEDIR")) + "/" + KStandardDirs::kde_default("data")+"/kleandisk/pics/schedule_yellow_broken.xpm"));
    	else
				i -> setPixmap(7,QPixmap(QString(getenv("KDEDIR")) + "/" + KStandardDirs::kde_default("data")+"/kleandisk/pics/schedule_yellow.xpm"));
		}
		if (u -> getAction() == DELETE){
			if (u -> missedScheduleEvent())
				i -> setPixmap(7,QPixmap(QString(getenv("KDEDIR")) + "/" + KStandardDirs::kde_default("data")+"/kleandisk/pics/schedule_red_broken.xpm"));
			else	
				i -> setPixmap(7,QPixmap(QString(getenv("KDEDIR")) + "/" + KStandardDirs::kde_default("data")+"/kleandisk/pics/schedule_red.xpm"));
		}
		if (u -> getAction() == ARCHIVE){
			if (u -> missedScheduleEvent())
				i -> setPixmap(6,QPixmap(QString(getenv("KDEDIR")) + "/" + KStandardDirs::kde_default("data")+"/kleandisk/pics/schedule_green_broken.xpm"));
			else	
				i -> setPixmap(7,QPixmap(QString(getenv("KDEDIR")) + "/" + KStandardDirs::kde_default("data")+"/kleandisk/pics/schedule_green.xpm"));
		}
	}
	else{
		if (u -> schedule() -> dayList().count()>0 || u -> schedule() -> dayCycle()>0)
			i -> setPixmap(7,QPixmap(QString(getenv("KDEDIR")) + "/" + KStandardDirs::kde_default("data")+"/kleandisk/pics/schedule_gray.xpm"));
		else
		i -> setPixmap(7,QPixmap());
 	}
}

void UDGItem::slotPopup(QListViewItem * i, const QPoint & p, int c){
	popup = new QPopupMenu();
	if (i == topItem()){
		popup -> insertItem(i18n("New UDG"),this,SLOT(slotNewUDG()));
	}
	if (i -> parent() == topItem()){
		parent() -> setSelected(i,true);
		popup -> insertItem(i18n("New UDG"),this,SLOT(slotNewUDG()));
		popup -> insertItem(i18n("Edit"),this,SLOT(slotEditUDG()));
		popup -> insertItem(i18n("Delete"),this,SLOT(slotDeleteUDG()));
		UDG * g = groupManager() -> udg(name(selectedItem()));
		if (g -> dir().left(1) == "/")
			popup -> insertItem(i18n("Update"),this,SLOT(slotUpdateUDG()));
		popup -> insertItem(i18n("Quick Archive"),this,SLOT(slotQuickArchive()));
		if (g -> scheduleEnabled())
			popup -> insertItem(i18n("Execute next scheduled action"),g,SLOT(slotAction()));
		connect(g, SIGNAL(Action()), SLOT(slotCleanupEnded()));
	}
	popup -> popup(p);
}

void UDGItem::slotNewUDG(){
	UDG * g = new UDG("");
	g -> setName(i18n("New Group"));
	UDGDialog * udgDialog = new UDGDialog(g);
	udgDialog -> exec();
	int r = udgDialog -> retValue();
	while(r == 1){
		udgDialog -> exec();
		r = udgDialog -> retValue();
	}
	if (r == 0){
		groupManager() -> add(g);
		udgToItem(g,new QListViewItem(topItem()));
	}
}

void UDGItem::slotEditUDG(){
	QListViewItem * i = selectedItem();
	UDG * g = groupManager() -> udg(name(selectedItem()));
	UDGDialog * udgDialog = new UDGDialog(g);
	udgDialog -> exec();
	int r = udgDialog -> retValue();
	while(r == 1){
		udgDialog -> exec();
		r = udgDialog -> retValue();
	}
	if (r == 0){
		udgToItem(g, i);
		emit setupFileList(g);
	}
}

void UDGItem::slotDeleteUDG(){
	if (KMessageBox::questionYesNo(0,i18n("Are you shure you want to delete this group?\n The files will remain on disk"),i18n("Delete Group")) == KMessageBox::Yes){
		QListViewItem * i = selectedItem();
		groupManager() -> udg(name(i)) -> unInstall() -> start();
		groupManager() -> remove(TYPE_UDG,name(i));
		delete i;
	}
}

void UDGItem::slotQuickArchive(){
	FileGroupExt * u = groupManager() -> udg(name(selectedItem()));
	u -> markAll();
	proc = u -> archive(u -> nextArchiveFileName(defaultArchiveDir()),u -> archiveRoot(), true);
	if (proc){
		progress = new ABProgress();
		progress -> show();
		progress -> QLabel_1 -> setText(i18n("Archive"));
		progress -> QProgressBar_1 -> setTotalSteps(u -> numMarked());
		connect(progress -> QPushButton_1, SIGNAL(clicked()),SLOT(slotQuickArchiveCancelClicked()));
		connect(proc, SIGNAL(processExited(KProcess*)), SLOT(slotQuickArchiveCompleted()));
		connect(proc, SIGNAL(receivedOutput(int,QString)), progress, SLOT(slotProgress(int,QString)));
		proc -> start(KProcess::NotifyOnExit,KProcess::AllOutput);
	}
}

void UDGItem::slotQuickArchiveCompleted(){
	delete progress;
	delete proc;
}

void UDGItem::slotCleanupEnded(){
//	delete cleanUpWizard;	
	UDG * g;
	g = groupManager() -> udg(name(selectedItem()));
	g -> empty();
	g-> loadFiles();
	udgToItem(g,selectedItem());
	groupViewWidget() -> FileListView1 -> setFileGroup(g);
}

void UDGItem::slotUpdateUDG(){
	UDG * g = groupManager() -> udg(name(selectedItem()));
	groupManager() -> update(TYPE_UDG, g -> dir());
}
