/***************************************************************************
                          udgeditcriteria.cpp  -  description
                             -------------------
    begin                : Fri Mar 24 2000
    copyright            : (C) 2000 by Arjan Buursink
    email                : buursink@casema.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "udgeditcriteria.h"
#include <stdlib.h>
#include <kapp.h>
#include "kfiledialog.h"
#include "addpatterndialog.h"

UDGEditCriteria::UDGEditCriteria(UDG * g, QWidget *parent, const char *name) : QWidget(parent,name){
	initDialog();
	connect(QPushButton_1, SIGNAL(clicked()),SLOT(slotAddPattern()));
	connect(QPushButton_2, SIGNAL(clicked()),SLOT(slotRemovePattern()));
	connect(QPushButton_3, SIGNAL(clicked()),SLOT(slotBrowse()));
	emptyGroup = false;
	groupToEditor(g);
}

UDGEditCriteria::~UDGEditCriteria(){
}

void UDGEditCriteria::slotAddPattern(){
	AddPatternDialog * dlg = new AddPatternDialog();
	QListBox_1 -> insertItem (dlg -> getPattern());
	delete dlg;
}

void UDGEditCriteria::slotRemovePattern(){
	emptyGroup = true;
	QListBox_1 -> removeItem(QListBox_1 -> currentItem());
}

void UDGEditCriteria::slotBrowse(){
	QLineEdit_1 -> setText(KFileDialog::getExistingDirectory(getenv("HOME")));
}

void UDGEditCriteria::groupToEditor(UDG * g){
	for (unsigned int i = 0; i < g -> patternList() -> count(); i++)
		QListBox_1 -> insertItem(g -> patternList() -> at(i) -> pattern());
	QLineEdit_1 -> setText(g -> dir());
	u = g;
}

void UDGEditCriteria::editorToGroup(){
	u -> clearPatternList();
	for (unsigned int i = 0; i < QListBox_1 -> count(); i++)
		u -> addPattern(QListBox_1 -> text(i));
	u -> setDir(QLineEdit_1 -> text());
	if (emptyGroup)
		u -> empty();
}

QString UDGEditCriteria::error(){
	QString e;
	e = QString::null;
	return e;
}